/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericRegexMatcher
extends GenericMatcher {
    protected Object[][] patterns;

    public void compile(Object[][] patterns) throws PatternSyntaxException {
        this.patterns = patterns;
        for (int i = 0; i < patterns.length; ++i) {
            String pattern = (String)patterns[i][1];
            patterns[i][1] = Pattern.compile(pattern);
        }
    }

    public abstract void init() throws MessagingException;

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        MimeMessage message = mail.getMessage();
        if (this.patterns != null) {
            for (int i = 0; i < this.patterns.length; ++i) {
                String headerName = (String)this.patterns[i][0];
                Pattern pattern = (Pattern)this.patterns[i][1];
                String[] headers = message.getHeader(headerName);
                if (headers == null) continue;
                for (int j = 0; j < headers.length; ++j) {
                    if (!pattern.matcher(headers[j]).matches()) continue;
                    return mail.getRecipients();
                }
            }
        }
        return null;
    }
}

