/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HasHabeasWarrantMark
extends GenericMatcher {
    public static final String[][] warrantMark = new String[][]{{"X-Habeas-SWE-1", "winter into spring"}, {"X-Habeas-SWE-2", "brightly anticipated"}, {"X-Habeas-SWE-3", "like Habeas SWE (tm)"}, {"X-Habeas-SWE-4", "Copyright 2002 Habeas (tm)"}, {"X-Habeas-SWE-5", "Sender Warranted Email (SWE) (tm). The sender of this"}, {"X-Habeas-SWE-6", "email in exchange for a license for this Habeas"}, {"X-Habeas-SWE-7", "warrant mark warrants that this is a Habeas Compliant"}, {"X-Habeas-SWE-8", "Message (HCM) and not spam. Please report use of this"}, {"X-Habeas-SWE-9", "mark in spam to <http://www.habeas.com/report/>."}};

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        MimeMessage message = mail.getMessage();
        for (int i = 0; i < warrantMark.length; ++i) {
            try {
                String headerName = warrantMark[i][0];
                String requiredValue = warrantMark[i][1];
                String headerValue = message.getHeader(headerName, null);
                if (requiredValue.equals(headerValue)) continue;
                return null;
            }
            catch (Exception e) {
                this.log(e.toString());
                return null;
            }
        }
        return mail.getRecipients();
    }

    public String getMatcherInfo() {
        return "Habeas Warrant Mark Matcher (see http://www.habeas.com for details).";
    }
}

