/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HasHeader
extends GenericMatcher {
    private LinkedList<String> conditionline_ = new LinkedList();

    public void init() throws MessagingException {
        StringTokenizer st = new StringTokenizer(this.getCondition(), "+");
        this.conditionline_ = new LinkedList();
        while (st.hasMoreTokens()) {
            String condition = st.nextToken().trim();
            this.conditionline_.add(condition);
        }
    }

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        boolean match = false;
        MimeMessage message = mail.getMessage();
        for (String element : this.conditionline_) {
            StringTokenizer st = new StringTokenizer(element, "=", false);
            String header = new String();
            if (!st.hasMoreTokens()) {
                throw new MessagingException("Missing headerName");
            }
            header = st.nextToken().trim();
            String headerValue = new String();
            headerValue = st.hasMoreTokens() ? st.nextToken().trim() : null;
            String[] headerArray = message.getHeader(header);
            if (headerArray != null && headerArray.length > 0) {
                if (headerValue != null) {
                    if (headerArray[0].trim().equalsIgnoreCase(headerValue)) {
                        match = true;
                        continue;
                    }
                    match = false;
                    break;
                }
                match = true;
                continue;
            }
            match = false;
            break;
        }
        return match ? mail.getRecipients() : null;
    }
}

