/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.mail.MessagingException;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMTPAuthUserIs
extends GenericMatcher {
    private static final String SMTP_AUTH_USER_ATTRIBUTE_NAME = "org.apache.james.SMTPAuthUser";
    private Collection<String> users;

    public void init() throws MessagingException {
        StringTokenizer st = new StringTokenizer(this.getCondition(), ", \t", false);
        this.users = new HashSet<String>();
        while (st.hasMoreTokens()) {
            this.users.add(st.nextToken());
        }
    }

    public Collection<MailAddress> match(Mail mail) {
        String authUser = (String)((Object)mail.getAttribute(SMTP_AUTH_USER_ATTRIBUTE_NAME));
        if (authUser != null && this.users.contains(authUser)) {
            return mail.getRecipients();
        }
        return null;
    }
}

