/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SenderHostIs
extends GenericMatcher {
    private Collection<String> senderHosts;

    public void init() {
        StringTokenizer st = new StringTokenizer(this.getCondition(), ", ", false);
        this.senderHosts = new HashSet<String>();
        while (st.hasMoreTokens()) {
            this.senderHosts.add(st.nextToken().toLowerCase(Locale.US));
        }
        this.senderHosts = Collections.unmodifiableCollection(this.senderHosts);
    }

    public Collection<MailAddress> match(Mail mail) {
        try {
            if (mail.getSender() != null && this.senderHosts.contains(mail.getSender().getDomain().toLowerCase(Locale.US))) {
                return mail.getRecipients();
            }
        }
        catch (Exception e) {
            this.log(e.getMessage());
        }
        return null;
    }
}

