/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.mail.MessagingException;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SenderIsRegex
extends GenericMatcher {
    Pattern pattern = null;

    public void init() throws MessagingException {
        String patternString = this.getCondition();
        if (patternString == null || patternString.equals("")) {
            throw new MessagingException("Pattern is missing");
        }
        patternString = patternString.trim();
        try {
            this.pattern = Pattern.compile(patternString);
        }
        catch (PatternSyntaxException mpe) {
            throw new MessagingException("Malformed pattern: " + patternString, (Exception)mpe);
        }
    }

    public Collection<MailAddress> match(Mail mail) {
        MailAddress mailAddress = mail.getSender();
        if (mailAddress == null) {
            return null;
        }
        String senderString = mailAddress.toString();
        if (this.pattern.matcher(senderString).matches()) {
            return mail.getRecipients();
        }
        return null;
    }
}

