/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import java.util.Locale;
import javax.mail.MessagingException;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SizeGreaterThan
extends GenericMatcher {
    int cutoff = 0;

    public void init() throws MessagingException {
        String amount = this.getCondition();
        if (amount == null) {
            throw new MessagingException("Please configure an amount");
        }
        amount = amount.trim().toLowerCase(Locale.US);
        try {
            if (amount.endsWith("k")) {
                amount = amount.substring(0, amount.length() - 1);
                this.cutoff = Integer.parseInt(amount) * 1024;
            } else if (amount.endsWith("m")) {
                amount = amount.substring(0, amount.length() - 1);
                this.cutoff = Integer.parseInt(amount) * 1024 * 1024;
            } else {
                this.cutoff = Integer.parseInt(amount);
            }
        }
        catch (NumberFormatException e) {
            throw new MessagingException("Invalid amount: " + amount);
        }
    }

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        if (mail.getMessageSize() > (long)this.cutoff) {
            return mail.getRecipients();
        }
        return null;
    }
}

