/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.container.spring.lifecycle.osgi;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.osgi.context.BundleContextAware;
import org.springframework.osgi.service.importer.support.Cardinality;
import org.springframework.osgi.service.importer.support.OsgiServiceCollectionProxyFactoryBean;
import org.springframework.osgi.service.importer.support.OsgiServiceProxyFactoryBean;
import org.springframework.util.ReflectionUtils;

public abstract class AbstractOSGIAnnotationBeanPostProcessor<A extends Annotation>
extends InstantiationAwareBeanPostProcessorAdapter
implements BundleContextAware,
BeanClassLoaderAware,
BeanFactoryAware {
    public static final long DEFAULT_TIMEOUT = 300000L;
    private BundleContext bundleContext;
    private static Logger logger = LoggerFactory.getLogger(AbstractOSGIAnnotationBeanPostProcessor.class);
    protected BeanFactory beanFactory;
    private ClassLoader classLoader;
    private boolean lookupBeanFactory = true;
    private long timeout = 300000L;

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setLookupBeanFactory(boolean lookupBeanFactory) {
        this.lookupBeanFactory = lookupBeanFactory;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (logger.isDebugEnabled()) {
            logger.debug("processing [" + bean.getClass().getName() + ", " + beanName + "]");
        }
        if (!(bean instanceof FactoryBean) && this.beanFactory.containsBean("&" + beanName)) {
            this.injectServices(bean, beanName);
        }
        return bean;
    }

    private void injectServices(final Object bean, final String beanName) {
        ReflectionUtils.doWithMethods(bean.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) {
                Annotation s = AnnotationUtils.getAnnotation((Method)method, AbstractOSGIAnnotationBeanPostProcessor.this.getAnnotation());
                if (s != null && method.getParameterTypes().length == 1) {
                    try {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Processing annotation [" + s + "] for [" + bean.getClass().getName() + "." + method.getName() + "()] on bean [" + beanName + "]");
                        }
                        method.invoke(bean, AbstractOSGIAnnotationBeanPostProcessor.this.getServiceImporter(s, method, beanName).getObject());
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Error processing annotation " + s, e);
                    }
                }
            }
        });
    }

    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeansException {
        MutablePropertyValues newprops = new MutablePropertyValues(pvs);
        for (PropertyDescriptor pd : pds) {
            A s = this.hasAnnotatedProperty(pd);
            if (s == null || pvs.contains(pd.getName())) continue;
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Processing annotation [" + s + "] for [" + beanName + "." + pd.getName() + "]");
                }
                FactoryBean importer = this.getServiceImporter(s, pd.getWriteMethod(), beanName);
                if (bean instanceof BeanPostProcessor) {
                    ImporterCallAdapter.setCardinality(importer, Cardinality.C_0__1);
                }
                newprops.addPropertyValue(pd.getName(), importer.getObject());
            }
            catch (Exception e) {
                throw new FatalBeanException("Could not create service reference", (Throwable)e);
            }
        }
        return newprops;
    }

    private FactoryBean getServiceImporter(A s, Method writeMethod, String beanName) throws Exception {
        Class<?>[] params = writeMethod.getParameterTypes();
        if (params.length != 1) {
            throw new IllegalArgumentException("Setter for [" + beanName + "] must have only one argument");
        }
        if (this.lookupBeanFactory) {
            Object bean;
            if (logger.isDebugEnabled()) {
                logger.debug("Lookup the bean via the BeanFactory");
            }
            Class<?> clazz = writeMethod.getParameterTypes()[0];
            try {
                bean = this.getBeanFromFactory(s, clazz);
            }
            catch (NoSuchBeanDefinitionException e) {
                bean = null;
            }
            if (bean != null) {
                final Object fBean = bean;
                return new FactoryBean(){

                    public Object getObject() throws Exception {
                        return fBean;
                    }

                    public Class getObjectType() {
                        return fBean.getClass();
                    }

                    public boolean isSingleton() {
                        return true;
                    }
                };
            }
        }
        return this.getResourceProperty(new OsgiServiceProxyFactoryBean(), this.getFilter(s), writeMethod, beanName);
    }

    private FactoryBean getResourceProperty(OsgiServiceProxyFactoryBean pfb, String filter, Method writeMethod, String beanName) throws Exception {
        pfb.setTimeout(this.timeout);
        if (filter != null) {
            ImporterCallAdapter.setFilter(pfb, filter);
        }
        ImporterCallAdapter.setInterfaces(pfb, writeMethod.getParameterTypes());
        ImporterCallAdapter.setBundleContext(pfb, this.bundleContext);
        ImporterCallAdapter.setBeanClassLoader(pfb, this.classLoader);
        ImporterCallAdapter.afterPropertiesSet(pfb);
        return pfb;
    }

    private A hasAnnotatedProperty(PropertyDescriptor propertyDescriptor) {
        Method setter = propertyDescriptor.getWriteMethod();
        return (A)(setter != null ? AnnotationUtils.getAnnotation((Method)setter, this.getAnnotation()) : null);
    }

    public void setBundleContext(BundleContext context) {
        this.bundleContext = context;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected abstract Class<A> getAnnotation();

    protected abstract String getFilter(A var1);

    protected abstract Object getBeanFromFactory(A var1, Class<?> var2);

    private static abstract class ImporterCallAdapter {
        private ImporterCallAdapter() {
        }

        static void setInterfaces(Object importer, Class[] classes) {
            if (importer instanceof OsgiServiceProxyFactoryBean) {
                ((OsgiServiceProxyFactoryBean)importer).setInterfaces(classes);
            } else {
                ((OsgiServiceCollectionProxyFactoryBean)importer).setInterfaces(classes);
            }
        }

        static void setBundleContext(Object importer, BundleContext context) {
            ((BundleContextAware)importer).setBundleContext(context);
        }

        static void setBeanClassLoader(Object importer, ClassLoader cl) {
            ((BeanClassLoaderAware)importer).setBeanClassLoader(cl);
        }

        static void setCardinality(Object importer, Cardinality cardinality) {
            if (importer instanceof OsgiServiceProxyFactoryBean) {
                ((OsgiServiceProxyFactoryBean)importer).setCardinality(cardinality);
            } else {
                ((OsgiServiceCollectionProxyFactoryBean)importer).setCardinality(cardinality);
            }
        }

        static void afterPropertiesSet(Object importer) throws Exception {
            ((InitializingBean)importer).afterPropertiesSet();
        }

        static void setFilter(Object importer, String filter) throws Exception {
            if (importer instanceof OsgiServiceProxyFactoryBean) {
                ((OsgiServiceProxyFactoryBean)importer).setFilter(filter);
            } else {
                ((OsgiServiceCollectionProxyFactoryBean)importer).setFilter(filter);
            }
        }

        static void setServiceBean(Object importer, String name) {
            if (importer instanceof OsgiServiceProxyFactoryBean) {
                ((OsgiServiceProxyFactoryBean)importer).setServiceBeanName(name);
            } else {
                ((OsgiServiceCollectionProxyFactoryBean)importer).setServiceBeanName(name);
            }
        }
    }
}

