/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.impl;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.lifecycle.api.LogEnabled;
import org.apache.james.mailetcontainer.api.MailProcessor;
import org.apache.james.mailetcontainer.api.jmx.MailSpoolerMBean;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.util.concurrent.JMXEnabledThreadPoolExecutor;
import org.apache.mailet.Mail;
import org.slf4j.Logger;

public class JamesMailSpooler
implements Runnable,
Configurable,
LogEnabled,
MailSpoolerMBean {
    private MailQueue queue;
    private int numThreads;
    private AtomicInteger numActive = new AtomicInteger(0);
    private AtomicInteger processingActive = new AtomicInteger(0);
    private AtomicBoolean active = new AtomicBoolean(false);
    private ExecutorService dequeueService;
    private ExecutorService workerService;
    private MailProcessor mailProcessor;
    private Logger logger;
    private MailQueueFactory queueFactory;
    private int numDequeueThreads;

    @Resource(name="mailqueuefactory")
    public void setMailQueueFactory(MailQueueFactory queueFactory) {
        this.queueFactory = queueFactory;
    }

    @Resource(name="mailprocessor")
    public void setMailProcessor(MailProcessor mailProcessor) {
        this.mailProcessor = mailProcessor;
    }

    public void configure(HierarchicalConfiguration config) throws ConfigurationException {
        this.numDequeueThreads = config.getInt("dequeueThreads", 2);
        this.numThreads = config.getInt("threads", 100);
    }

    @PostConstruct
    public void init() throws Exception {
        this.logger.info(this.getClass().getName() + " init...");
        this.queue = this.queueFactory.getQueue("spool");
        if (this.logger.isInfoEnabled()) {
            StringBuffer infoBuffer = new StringBuffer(64).append(this.getClass().getName()).append(" uses ").append(this.numThreads).append(" Thread(s)");
            this.logger.info(infoBuffer.toString());
        }
        this.active.set(true);
        this.workerService = JMXEnabledThreadPoolExecutor.newFixedThreadPool((String)"org.apache.james:type=component,component=mailetcontainer,name=mailspooler,sub-type=threadpool", (String)"spooler", (int)this.numThreads);
        this.dequeueService = JMXEnabledThreadPoolExecutor.newFixedThreadPool((String)"org.apache.james:type=component,component=mailetcontainer,name=mailspooler,sub-type=threadpool", (String)"dequeuer", (int)this.numDequeueThreads);
        for (int i = 0; i < this.numDequeueThreads; ++i) {
            Thread reader = new Thread((Runnable)this, "Dequeue Thread #" + i);
            this.dequeueService.execute(reader);
        }
    }

    @Override
    public void run() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Run " + this.getClass().getName() + ": " + Thread.currentThread().getName());
            this.logger.info("Queue=" + this.queue.toString());
        }
        while (this.active.get()) {
            try {
                final MailQueue.MailQueueItem queueItem = this.queue.deQueue();
                this.workerService.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            JamesMailSpooler.this.numActive.incrementAndGet();
                            JamesMailSpooler.this.processingActive.incrementAndGet();
                            Mail mail = queueItem.getMail();
                            if (JamesMailSpooler.this.logger.isDebugEnabled()) {
                                StringBuffer debugBuffer = new StringBuffer(64).append("==== Begin processing mail ").append(mail.getName()).append("====");
                                JamesMailSpooler.this.logger.debug(debugBuffer.toString());
                            }
                            try {
                                JamesMailSpooler.this.mailProcessor.service(mail);
                                queueItem.done(true);
                            }
                            catch (Exception e) {
                                if (JamesMailSpooler.this.active.get() && JamesMailSpooler.this.logger.isErrorEnabled()) {
                                    JamesMailSpooler.this.logger.error("Exception processing mail while spooling " + e.getMessage(), (Throwable)e);
                                }
                                queueItem.done(false);
                            }
                            finally {
                                LifecycleUtil.dispose((Object)mail);
                                mail = null;
                            }
                        }
                        catch (Throwable e) {
                            if (JamesMailSpooler.this.active.get() && JamesMailSpooler.this.logger.isErrorEnabled()) {
                                JamesMailSpooler.this.logger.error("Exception processing mail while spooling " + e.getMessage(), e);
                            }
                        }
                        finally {
                            JamesMailSpooler.this.processingActive.decrementAndGet();
                            JamesMailSpooler.this.numActive.decrementAndGet();
                        }
                    }
                });
            }
            catch (MailQueue.MailQueueException e1) {
                if (!this.active.get() || !this.logger.isErrorEnabled()) continue;
                this.logger.error("Exception dequeue mail", (Throwable)e1);
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Stop " + this.getClass().getName() + ": " + Thread.currentThread().getName());
        }
    }

    @PreDestroy
    public void dispose() {
        this.logger.info(this.getClass().getName() + " dispose...");
        this.active.set(false);
        this.dequeueService.shutdownNow();
        this.workerService.shutdown();
        long stop = System.currentTimeMillis() + 60000L;
        while (this.numActive.get() != 0 && stop > System.currentTimeMillis()) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        this.logger.info(this.getClass().getName() + " thread shutdown completed.");
    }

    public void setLog(Logger log) {
        this.logger = log;
    }

    public int getThreadCount() {
        return this.numThreads;
    }

    public int getCurrentSpoolCount() {
        return this.processingActive.get();
    }
}

