/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.annotation.Resource;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.ParseException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.core.MailImpl;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.dnsservice.api.TemporaryResolutionException;
import org.apache.james.dnsservice.library.MXHostAddressIterator;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.lifecycle.api.LogEnabled;
import org.apache.james.mailetcontainer.api.MailProcessor;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.mailet.HostAddress;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.MailetContext;
import org.slf4j.Logger;

public class JamesMailetContext
implements MailetContext,
LogEnabled,
Configurable {
    private Hashtable<String, Object> attributes = new Hashtable();
    protected DNSService dns;
    protected Logger log;
    private UsersRepository localusers;
    private MailProcessor processorList;
    private DomainList domains;
    private MailAddress postmaster;

    @Resource(name="mailprocessor")
    public void setMailProcessor(MailProcessor processorList) {
        this.processorList = processorList;
    }

    @Resource(name="dnsservice")
    public void setDNSService(DNSService dns) {
        this.dns = dns;
    }

    @Resource(name="usersrepository")
    public void setUsersRepository(UsersRepository localusers) {
        this.localusers = localusers;
    }

    @Resource(name="domainlist")
    public void setDomainList(DomainList domains) {
        this.domains = domains;
    }

    public Collection<String> getMailServers(String host) {
        try {
            return this.dns.findMXRecords(host);
        }
        catch (TemporaryResolutionException e) {
            return Collections.unmodifiableCollection(new ArrayList(0));
        }
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, Object object) {
        this.attributes.put(key, object);
    }

    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    public Iterator<String> getAttributeNames() {
        Vector<String> names = new Vector<String>();
        Enumeration<String> e = this.attributes.keys();
        while (e.hasMoreElements()) {
            names.add(e.nextElement());
        }
        return names.iterator();
    }

    public void bounce(Mail mail, String message) throws MessagingException {
        this.bounce(mail, message, this.getPostmaster());
    }

    public void bounce(Mail mail, String message, MailAddress bouncer) throws MessagingException {
        if (mail.getSender() == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Mail to be bounced contains a null (<>) reverse path.  No bounce will be sent.");
            }
            return;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Processing a bounce request for a message with a reverse path of " + mail.getSender().toString());
        }
        MailImpl reply = this.rawBounce(mail, message);
        reply.getMessage().setFrom((Address)bouncer.toInternetAddress());
        reply.getMessage().saveChanges();
        reply.setSender(null);
        this.sendMail((Mail)reply);
        LifecycleUtil.dispose((Object)reply);
    }

    private MailImpl rawBounce(Mail mail, String bounceText) throws MessagingException {
        MimeMessage original = mail.getMessage();
        MimeMessage reply = (MimeMessage)original.reply(false);
        reply.setSubject("Re: " + original.getSubject());
        reply.setSentDate(new Date());
        HashSet<MailAddress> recipients = new HashSet<MailAddress>();
        recipients.add(mail.getSender());
        InternetAddress[] addr = new InternetAddress[]{new InternetAddress(mail.getSender().toString())};
        reply.setRecipients(Message.RecipientType.TO, (Address[])addr);
        reply.setFrom((Address)new InternetAddress(mail.getRecipients().iterator().next().toString()));
        reply.setText(bounceText);
        reply.setHeader("Message-ID", "replyTo-" + mail.getName());
        return new MailImpl("replyTo-" + mail.getName(), new MailAddress(mail.getRecipients().iterator().next().toString()), recipients, reply);
    }

    public boolean isLocalUser(String name) {
        if (name == null) {
            return false;
        }
        try {
            if (name.indexOf("@") == -1) {
                try {
                    return this.isLocalEmail(new MailAddress(name, this.domains.getDefaultDomain()));
                }
                catch (DomainListException e) {
                    this.log("Unable to access DomainList", e);
                    return false;
                }
            }
            return this.isLocalEmail(new MailAddress(name));
        }
        catch (ParseException e) {
            this.log("Error checking isLocalUser for user " + name);
            return false;
        }
    }

    public boolean isLocalEmail(MailAddress mailAddress) {
        String userName = mailAddress.toString();
        if (!this.isLocalServer(mailAddress.getDomain())) {
            return false;
        }
        try {
            if (!this.localusers.supportVirtualHosting()) {
                userName = mailAddress.getLocalPart();
            }
            return this.localusers.contains(userName);
        }
        catch (UsersRepositoryException e) {
            this.log("Unable to access UsersRepository", e);
            return false;
        }
    }

    public MailAddress getPostmaster() {
        return this.postmaster;
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 4;
    }

    public Iterator<HostAddress> getSMTPHostAddresses(String domainName) {
        try {
            return new MXHostAddressIterator(this.dns.findMXRecords(domainName).iterator(), this.dns, false, this.log);
        }
        catch (TemporaryResolutionException e) {
            return Collections.unmodifiableCollection(new ArrayList(0)).iterator();
        }
    }

    public String getServerInfo() {
        return "Apache JAMES";
    }

    public boolean isLocalServer(String name) {
        try {
            return this.domains.containsDomain(name);
        }
        catch (DomainListException e) {
            this.log.error("Unable to retrieve domains", (Throwable)e);
            return false;
        }
    }

    public void log(String arg0) {
        this.log.info(arg0);
    }

    public void log(String arg0, Throwable arg1) {
        this.log.info(arg0, arg1);
    }

    public void sendMail(MimeMessage message) throws MessagingException {
        MailAddress sender = new MailAddress((InternetAddress)message.getFrom()[0]);
        HashSet<MailAddress> recipients = new HashSet<MailAddress>();
        Address[] addresses = message.getAllRecipients();
        if (addresses != null) {
            for (int i = 0; i < addresses.length; ++i) {
                if (!(addresses[i] instanceof InternetAddress)) continue;
                recipients.add(new MailAddress((InternetAddress)addresses[i]));
            }
        }
        this.sendMail(sender, recipients, message);
    }

    public void sendMail(MailAddress sender, Collection recipients, MimeMessage message) throws MessagingException {
        this.sendMail(sender, recipients, message, "root");
    }

    public void sendMail(Mail mail) throws MessagingException {
        this.processorList.service(mail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMail(MailAddress sender, Collection recipients, MimeMessage message, String state) throws MessagingException {
        MailImpl mail = new MailImpl(MailImpl.getId(), sender, recipients, message);
        try {
            mail.setState(state);
            this.sendMail((Mail)mail);
        }
        finally {
            LifecycleUtil.dispose((Object)mail);
        }
    }

    public void storeMail(MailAddress sender, MailAddress recipient, MimeMessage msg) throws MessagingException {
        throw new UnsupportedOperationException("Was removed");
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    public void configure(HierarchicalConfiguration config) throws ConfigurationException {
        try {
            String postMasterAddress = config.getString("postmaster", "postmaster").toLowerCase(Locale.US);
            if (postMasterAddress.indexOf(64) < 0) {
                String domainName = null;
                String[] doms = this.domains.getDomains();
                if (doms != null) {
                    for (int i = 0; i < doms.length; ++i) {
                        String serverName = doms[i].toLowerCase(Locale.US);
                        if ("localhost".equals(serverName)) continue;
                        domainName = serverName;
                    }
                }
                postMasterAddress = postMasterAddress + "@" + (domainName != null ? domainName : this.domains.getDefaultDomain());
            }
            try {
                this.postmaster = new MailAddress(postMasterAddress);
                if (!this.domains.containsDomain(this.postmaster.getDomain())) {
                    StringBuffer warnBuffer = new StringBuffer(320).append("The specified postmaster address ( ").append(this.postmaster).append(" ) is not a local address.  This is not necessarily a problem, but it does mean that emails addressed to the postmaster will be routed to another server.  For some configurations this may cause problems.");
                    this.log.warn(warnBuffer.toString());
                }
            }
            catch (AddressException e) {
                throw new ConfigurationException("Postmaster address " + postMasterAddress + "is invalid", (Throwable)e);
            }
        }
        catch (DomainListException e) {
            throw new ConfigurationException("Unable to access DomainList", (Throwable)e);
        }
    }
}

