/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.MailetContext;

public class MailetConfigImpl
implements MailetConfig {
    private MailetContext mailetContext;
    private String name;
    private Configuration configuration;

    public String getInitParameter(String name) {
        return this.configuration.getString(name);
    }

    public Iterator<String> getInitParameterNames() {
        Iterator it = this.configuration.getKeys();
        ArrayList<String> params = new ArrayList<String>();
        while (it.hasNext()) {
            String param = (String)it.next();
            if (param.startsWith("[@") && param.endsWith("]")) continue;
            params.add(param);
        }
        return params.iterator();
    }

    public String getInitAttribute(String name) {
        return this.configuration.getString("[@" + name + "]", null);
    }

    public MailetContext getMailetContext() {
        return this.mailetContext;
    }

    public void setMailetContext(MailetContext newContext) {
        this.mailetContext = newContext;
    }

    public void setConfiguration(Configuration newConfiguration) {
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        builder.setDelimiterParsingDisabled(true);
        Iterator keys = newConfiguration.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String[] values = newConfiguration.getStringArray(key);
            key = key.replaceAll("\\.\\.", "\\.");
            StringBuilder valueBuilder = new StringBuilder();
            for (int i = 0; i < values.length; ++i) {
                valueBuilder.append(values[i]);
                if (i + 1 >= values.length) continue;
                valueBuilder.append(",");
            }
            builder.addProperty(key, (Object)valueBuilder.toString());
        }
        this.configuration = builder;
    }

    public String getMailetName() {
        return this.name;
    }

    public void setMailetName(String newName) {
        this.name = newName;
    }
}

