/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.impl.camel;

import java.util.List;
import java.util.Locale;
import javax.mail.MessagingException;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.james.mailetcontainer.impl.MailetConfigImpl;
import org.apache.james.mailetcontainer.impl.ProcessorUtil;
import org.apache.james.mailetcontainer.impl.camel.CamelMailetProcessor;
import org.apache.james.mailetcontainer.lib.AbstractStateMailetProcessor;
import org.apache.mailet.Mail;
import org.apache.mailet.Mailet;
import org.apache.mailet.MailetConfig;
import org.slf4j.Logger;

public class CamelProcessor
implements Processor {
    private Mailet mailet;
    private Logger logger;
    private CamelMailetProcessor processor;

    public CamelProcessor(Mailet mailet, Logger logger, CamelMailetProcessor processor) {
        this.mailet = mailet;
        this.logger = logger;
        this.processor = processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        Mail mail = (Mail)exchange.getIn().getBody(Mail.class);
        long start = System.currentTimeMillis();
        MessagingException ex = null;
        try {
            this.mailet.service(mail);
        }
        catch (MessagingException me) {
            ex = me;
            String onMailetException = null;
            MailetConfig mailetConfig = this.mailet.getMailetConfig();
            if (mailetConfig instanceof MailetConfigImpl) {
                onMailetException = ((MailetConfigImpl)mailetConfig).getInitAttribute("onMailetException");
            }
            if ((onMailetException = onMailetException == null ? "error" : onMailetException.trim().toLowerCase(Locale.US)).compareTo("ignore") == 0) {
                ProcessorUtil.verifyMailAddresses(mail.getRecipients());
            }
            ProcessorUtil.handleException(me, mail, this.mailet.getMailetConfig().getMailetName(), onMailetException, this.logger);
        }
        finally {
            List<AbstractStateMailetProcessor.MailetProcessorListener> listeners = this.processor.getListeners();
            long complete = System.currentTimeMillis() - start;
            for (int i = 0; i < listeners.size(); ++i) {
                AbstractStateMailetProcessor.MailetProcessorListener listener = listeners.get(i);
                listener.afterMailet(this.mailet, mail.getName(), mail.getState(), complete, ex);
            }
        }
    }
}

