/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.impl.jmx;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.james.lifecycle.api.Disposable;
import org.apache.james.mailetcontainer.api.MailProcessor;
import org.apache.james.mailetcontainer.impl.jmx.MailProcessorManagement;
import org.apache.james.mailetcontainer.lib.AbstractStateCompositeProcessor;

public class JMXStateCompositeProcessorListener
implements AbstractStateCompositeProcessor.CompositeProcessorListener,
Disposable {
    private AbstractStateCompositeProcessor mList;
    private MBeanServer mbeanserver;
    private List<ObjectName> mbeans = new ArrayList<ObjectName>();
    private Map<MailProcessor, MailProcessorManagement> mMap = new HashMap<MailProcessor, MailProcessorManagement>();

    public JMXStateCompositeProcessorListener(AbstractStateCompositeProcessor mList) throws MalformedObjectNameException, JMException {
        this.mList = mList;
        this.mbeanserver = ManagementFactory.getPlatformMBeanServer();
        this.registerMBeans();
    }

    private void unregisterMBeans() {
        ArrayList<ObjectName> unregistered = new ArrayList<ObjectName>();
        for (int i = 0; i < this.mbeans.size(); ++i) {
            ObjectName name = this.mbeans.get(i);
            try {
                this.mbeanserver.unregisterMBean(name);
                unregistered.add(name);
                continue;
            }
            catch (JMException e) {
                // empty catch block
            }
        }
        this.mbeans.removeAll(unregistered);
    }

    private void registerMBeans() throws MalformedObjectNameException, JMException {
        String baseObjectName = "org.apache.james:type=component,component=mailetcontainer,name=processor,";
        String[] processorNames = this.mList.getProcessorStates();
        for (int i = 0; i < processorNames.length; ++i) {
            String processorName = processorNames[i];
            this.registerProcessorMBean(baseObjectName, processorName);
        }
    }

    private void registerProcessorMBean(String baseObjectName, String processorName) throws MalformedObjectNameException, JMException {
        String processorMBeanName = baseObjectName + "processor=" + processorName;
        MailProcessorManagement processorDetail = new MailProcessorManagement(processorName);
        this.registerMBean(processorMBeanName, processorDetail);
        this.mMap.put(this.mList.getProcessor(processorName), processorDetail);
    }

    private void registerMBean(String mBeanName, Object object) throws MalformedObjectNameException, JMException {
        ObjectName objectName = new ObjectName(mBeanName);
        this.mbeanserver.registerMBean(object, objectName);
        this.mbeans.add(objectName);
    }

    @Override
    public void afterProcessor(MailProcessor processor, String mailName, long processTime, MessagingException e) {
        MailProcessorManagement m = this.mMap.get(processor);
        if (m != null) {
            m.update(processTime, e == null);
        }
    }

    public void dispose() {
        this.unregisterMBeans();
        this.mMap.clear();
    }
}

