/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.impl.jmx;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.james.lifecycle.api.Disposable;
import org.apache.james.mailetcontainer.impl.jmx.MailetManagement;
import org.apache.james.mailetcontainer.impl.jmx.MatcherManagement;
import org.apache.james.mailetcontainer.impl.matchers.CompositeMatcher;
import org.apache.james.mailetcontainer.lib.AbstractStateMailetProcessor;
import org.apache.mailet.MailAddress;
import org.apache.mailet.Mailet;
import org.apache.mailet.Matcher;

public class JMXStateMailetProcessorListener
implements AbstractStateMailetProcessor.MailetProcessorListener,
Disposable {
    private AbstractStateMailetProcessor processor;
    private MBeanServer mbeanserver;
    private List<ObjectName> mbeans = new ArrayList<ObjectName>();
    private Map<Mailet, MailetManagement> mailetMap = new HashMap<Mailet, MailetManagement>();
    private Map<Matcher, MatcherManagement> matcherMap = new HashMap<Matcher, MatcherManagement>();
    private String name;

    public JMXStateMailetProcessorListener(String name, AbstractStateMailetProcessor processor) throws MalformedObjectNameException, JMException {
        this.processor = processor;
        this.name = name;
        this.mbeanserver = ManagementFactory.getPlatformMBeanServer();
        this.registerMBeans();
    }

    @Override
    public void afterMailet(Mailet m, String mailName, String state, long processTime, MessagingException e) {
        MailetManagement mgmt = this.mailetMap.get(m);
        if (mgmt != null) {
            mgmt.update(processTime, e == null);
        }
    }

    @Override
    public void afterMatcher(Matcher m, String mailName, Collection<MailAddress> rcpts, Collection<MailAddress> matches, long processTime, MessagingException e) {
        MatcherManagement mgmt = this.matcherMap.get(m);
        if (mgmt != null) {
            boolean matched = false;
            if (matches != null) {
                matched = !matches.isEmpty();
            }
            mgmt.update(processTime, e == null, matched);
        }
    }

    private void registerMBeans() throws MalformedObjectNameException, JMException {
        String baseObjectName = "org.apache.james:type=component,component=mailetcontainer,name=processor,processor=" + this.name;
        this.registerMailets(baseObjectName, this.processor.getMailets().iterator());
        this.registerMatchers(baseObjectName, this.processor.getMatchers().iterator(), 0);
    }

    private void registerMailets(String parentMBeanName, Iterator<Mailet> mailets) throws MalformedObjectNameException, JMException {
        int i = 0;
        while (mailets.hasNext()) {
            Mailet mailet = mailets.next();
            MailetManagement mailetManagement = new MailetManagement(mailet.getMailetConfig());
            String mailetMBeanName = parentMBeanName + ",subtype=mailet,index=" + i++ + ",mailetname=" + mailetManagement.getMailetName();
            this.registerMBean(mailetMBeanName, mailetManagement);
            this.mailetMap.put(mailet, mailetManagement);
        }
    }

    private void registerMatchers(String parentMBeanName, Iterator<Matcher> matchers, int nestingLevel) throws MalformedObjectNameException, JMException {
        int currentLevel = nestingLevel;
        int i = 0;
        while (matchers.hasNext()) {
            Matcher matcher = matchers.next();
            MatcherManagement matcherManagement = new MatcherManagement(matcher.getMatcherConfig());
            String matcherMBeanName = parentMBeanName + ",subtype" + currentLevel + "=matcher,index" + currentLevel + "=" + i++ + ",matchername" + currentLevel + "=" + matcherManagement.getMatcherName();
            this.registerMBean(matcherMBeanName, matcherManagement);
            this.matcherMap.put(matcher, matcherManagement);
            if (!(matcher instanceof CompositeMatcher)) continue;
            this.registerMatchers(matcherMBeanName, ((CompositeMatcher)matcher).iterator(), ++nestingLevel);
        }
    }

    private void registerMBean(String mBeanName, Object object) throws MalformedObjectNameException, JMException {
        ObjectName objectName = new ObjectName(mBeanName);
        this.mbeanserver.registerMBean(object, objectName);
        this.mbeans.add(objectName);
    }

    public void dispose() {
        this.unregisterMBeans();
        this.mailetMap.clear();
        this.matcherMap.clear();
    }

    private void unregisterMBeans() {
        ArrayList<ObjectName> unregistered = new ArrayList<ObjectName>();
        for (int i = 0; i < this.mbeans.size(); ++i) {
            ObjectName name = this.mbeans.get(i);
            try {
                this.mbeanserver.unregisterMBean(name);
                unregistered.add(name);
                continue;
            }
            catch (JMException e) {
                // empty catch block
            }
        }
        this.mbeans.removeAll(unregistered);
    }
}

