/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.lib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.mail.MessagingException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.lifecycle.api.LogEnabled;
import org.apache.james.mailetcontainer.api.MailProcessor;
import org.apache.james.mailetcontainer.impl.jmx.JMXStateCompositeProcessorListener;
import org.apache.james.mailetcontainer.lib.AbstractStateMailetProcessor;
import org.apache.mailet.Mail;
import org.slf4j.Logger;

public abstract class AbstractStateCompositeProcessor
implements MailProcessor,
Configurable,
LogEnabled {
    private List<CompositeProcessorListener> listeners = Collections.synchronizedList(new ArrayList());
    private final Map<String, MailProcessor> processors = new HashMap<String, MailProcessor>();
    protected Logger logger;
    protected HierarchicalConfiguration config;
    private JMXStateCompositeProcessorListener jmxListener;
    private boolean enableJmx = true;

    public void setLog(Logger log) {
        this.logger = log;
    }

    public void addListener(CompositeProcessorListener listener) {
        this.listeners.add(listener);
    }

    public List<CompositeProcessorListener> getListeners() {
        return this.listeners;
    }

    public void removeListener(CompositeProcessorListener listener) {
        this.listeners.remove(listener);
    }

    public void configure(HierarchicalConfiguration config) throws ConfigurationException {
        this.config = config;
        this.enableJmx = config.getBoolean("[@enableJmx]", true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void service(Mail mail) throws MessagingException {
        long start = System.currentTimeMillis();
        MessagingException ex = null;
        MailProcessor processor = this.getProcessor(mail.getState());
        if (processor == null) throw new MessagingException("No processor found for mail " + mail.getName() + " with state " + mail.getState());
        this.logger.debug("Call MailProcessor " + mail.getState());
        try {
            processor.service(mail);
            if (!"ghost".equals(mail.getState())) return;
            LifecycleUtil.dispose((Object)mail);
            return;
        }
        catch (MessagingException e) {
            ex = e;
            throw e;
        }
        finally {
            long end = System.currentTimeMillis() - start;
            for (int i = 0; i < this.listeners.size(); ++i) {
                CompositeProcessorListener listener = this.listeners.get(i);
                listener.afterProcessor(processor, mail.getName(), end, ex);
            }
        }
    }

    public MailProcessor getProcessor(String state) {
        return this.processors.get(state);
    }

    public String[] getProcessorStates() {
        return this.processors.keySet().toArray(new String[this.processors.size()]);
    }

    private void checkProcessors() throws ConfigurationException {
        boolean errorProcessorFound = false;
        boolean rootProcessorFound = false;
        for (String name : this.processors.keySet()) {
            if (name.equals("root")) {
                rootProcessorFound = true;
            } else if (name.equals("error")) {
                errorProcessorFound = true;
            }
            if (!errorProcessorFound || !rootProcessorFound) continue;
            return;
        }
        if (!errorProcessorFound) {
            throw new ConfigurationException("You need to configure a Processor with name error");
        }
        if (!rootProcessorFound) {
            throw new ConfigurationException("You need to configure a Processor with name root");
        }
    }

    @PostConstruct
    public void init() throws Exception {
        List processorConfs = this.config.configurationsAt("processor");
        for (int i = 0; i < processorConfs.size(); ++i) {
            HierarchicalConfiguration processorConf = (HierarchicalConfiguration)processorConfs.get(i);
            String processorName = processorConf.getString("[@state]");
            if (!processorConf.containsKey("[@enableJmx]")) {
                processorConf.addProperty("[@enableJmx]", (Object)this.enableJmx);
            }
            this.processors.put(processorName, this.createMailProcessor(processorName, processorConf));
        }
        if (this.enableJmx) {
            this.jmxListener = new JMXStateCompositeProcessorListener(this);
            this.addListener(this.jmxListener);
        }
        this.checkProcessors();
    }

    @PreDestroy
    public void dispose() {
        String[] names = this.getProcessorStates();
        for (int i = 0; i < names.length; ++i) {
            MailProcessor processor = this.getProcessor(names[i]);
            if (!(processor instanceof AbstractStateMailetProcessor)) continue;
            ((AbstractStateMailetProcessor)processor).destroy();
        }
        if (this.jmxListener != null) {
            this.jmxListener.dispose();
        }
    }

    protected abstract MailProcessor createMailProcessor(String var1, HierarchicalConfiguration var2) throws Exception;

    public static interface CompositeProcessorListener {
        public void afterProcessor(MailProcessor var1, String var2, long var3, MessagingException var5);
    }
}

