/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.migrator;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.apache.james.mailbox.jpa.migrator.command.JpaMigrateCommand;
import org.apache.james.mailbox.jpa.migrator.exception.JpaMigrateException;

public class JpaMigrator {
    private static final String JPA_MIGRATION_COMMAND_PACKAGE = JpaMigrateCommand.class.getPackage().getName();

    public static void main(String[] jiras) throws JpaMigrateException {
        try {
            EntityManagerFactory factory = Persistence.createEntityManagerFactory((String)"JamesMigrator");
            EntityManager em = factory.createEntityManager();
            for (String jira : jiras) {
                JpaMigrateCommand jiraJpaMigratable = (JpaMigrateCommand)Class.forName(JPA_MIGRATION_COMMAND_PACKAGE + "." + jira.toUpperCase() + JpaMigrateCommand.class.getSimpleName()).newInstance();
                System.out.println("Now executing " + jira + " migration.");
                em.getTransaction().begin();
                jiraJpaMigratable.migrate(em);
                em.getTransaction().commit();
                System.out.println(jira + " migration is successfully achieved.");
            }
        }
        catch (Throwable t) {
            throw new JpaMigrateException(t);
        }
    }
}

