/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.MailImpl;
import org.apache.james.core.MimeMessageCopyOnWriteProxy;
import org.apache.james.core.MimeMessageInputStreamSource;
import org.apache.james.core.MimeMessageSource;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.protocols.api.ExtensibleHandler;
import org.apache.james.protocols.api.LineHandler;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.WiringException;
import org.apache.james.protocols.smtp.MailEnvelope;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.AbstractHookableCmdHandler;
import org.apache.james.protocols.smtp.core.DataLineFilter;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.Hook;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookResultHook;
import org.apache.james.protocols.smtp.hook.MessageHook;
import org.apache.james.smtpserver.JamesMessageHook;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;

public final class DataLineJamesMessageHookHandler
implements DataLineFilter,
ExtensibleHandler {
    private List<JamesMessageHook> messageHandlers;
    private List<HookResultHook> rHooks;
    private List<MessageHook> mHandlers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLine(SMTPSession session, byte[] line, LineHandler<SMTPSession> next) {
        MimeMessageInputStreamSource mmiss = (MimeMessageInputStreamSource)session.getState().get("org.apache.james.core.DataCmdHandler.DATA_MIMEMESSAGE_STREAMSOURCE");
        try {
            OutputStream out;
            block8: {
                block9: {
                    out = mmiss.getWritableOutputStream();
                    if (line.length != 3 || line[0] != 46) break block9;
                    out.flush();
                    out.close();
                    List recipientCollection = (List)session.getState().get("RCPT_LIST");
                    MailImpl mail = new MailImpl(MailImpl.getId(), (MailAddress)session.getState().get("SENDER_ADDRESS"), (Collection)recipientCollection);
                    session.getState().put("MAIL", mail);
                    MimeMessageCopyOnWriteProxy mimeMessageCopyOnWriteProxy = null;
                    try {
                        mimeMessageCopyOnWriteProxy = new MimeMessageCopyOnWriteProxy((MimeMessageSource)mmiss);
                        mail.setMessage((MimeMessage)mimeMessageCopyOnWriteProxy);
                        this.processExtensions(session, (Mail)mail);
                        session.popLineHandler();
                    }
                    catch (MessagingException e) {
                        try {
                            session.getLogger().info("Unexpected error handling DATA stream", (Throwable)e);
                            session.writeResponse((Response)new SMTPResponse("451", (CharSequence)"Unexpected error handling DATA stream."));
                        }
                        catch (Throwable throwable) {
                            LifecycleUtil.dispose(mimeMessageCopyOnWriteProxy);
                            LifecycleUtil.dispose((Object)mmiss);
                            LifecycleUtil.dispose((Object)mail);
                            throw throwable;
                        }
                        LifecycleUtil.dispose((Object)mimeMessageCopyOnWriteProxy);
                        LifecycleUtil.dispose((Object)mmiss);
                        LifecycleUtil.dispose((Object)mail);
                        break block8;
                    }
                    LifecycleUtil.dispose((Object)mimeMessageCopyOnWriteProxy);
                    LifecycleUtil.dispose((Object)mmiss);
                    LifecycleUtil.dispose((Object)mail);
                    break block8;
                }
                if (line[0] == 46 && line[1] == 46) {
                    out.write(line, 1, line.length - 1);
                } else {
                    out.write(line);
                }
            }
            out.flush();
        }
        catch (IOException e) {
            LifecycleUtil.dispose((Object)mmiss);
            SMTPResponse response = new SMTPResponse("451", (CharSequence)(DSNStatus.getStatus((int)4, (String)"0.0") + " Error processing message: " + e.getMessage()));
            session.getLogger().error("Unknown error occurred while processing DATA.", (Throwable)e);
            session.writeResponse((Response)response);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processExtensions(SMTPSession session, Mail mail) {
        if (mail != null && this.messageHandlers != null) {
            try {
                MimeMessageInputStreamSource mmiss = (MimeMessageInputStreamSource)session.getState().get("org.apache.james.core.DataCmdHandler.DATA_MIMEMESSAGE_STREAMSOURCE");
                OutputStream out = null;
                try {
                    out = mmiss.getWritableOutputStream();
                }
                catch (FileNotFoundException e) {
                    session.getLogger().debug("Unable to obtain OutputStream for Mail " + mail, (Throwable)e);
                }
                for (int i = 0; i < this.mHandlers.size(); ++i) {
                    SMTPResponse response;
                    MessageHook rawHandler = this.mHandlers.get(i);
                    session.getLogger().debug("executing james message handler " + rawHandler);
                    long start = System.currentTimeMillis();
                    HookResult hRes = rawHandler.onMessage(session, (MailEnvelope)new MailToMailEnvelopeWrapper(mail, out));
                    long executionTime = System.currentTimeMillis() - start;
                    if (this.rHooks != null) {
                        for (int i2 = 0; i2 < this.rHooks.size(); ++i2) {
                            HookResultHook rHook = this.rHooks.get(i2);
                            session.getLogger().debug("executing hook " + rHook);
                            hRes = rHook.onHookResult(session, hRes, executionTime, (Hook)rawHandler);
                        }
                    }
                    if ((response = AbstractHookableCmdHandler.calcDefaultSMTPResponse((HookResult)hRes)) == null) continue;
                    session.writeResponse((Response)response);
                    return;
                }
                int count = this.messageHandlers.size();
                for (int i = 0; i < count; ++i) {
                    SMTPResponse response;
                    Hook rawHandler = this.messageHandlers.get(i);
                    session.getLogger().debug("executing james message handler " + rawHandler);
                    long start = System.currentTimeMillis();
                    HookResult hRes = ((JamesMessageHook)rawHandler).onMessage(session, mail);
                    long executionTime = System.currentTimeMillis() - start;
                    if (this.rHooks != null) {
                        for (int i2 = 0; i2 < this.rHooks.size(); ++i2) {
                            HookResultHook rHook = this.rHooks.get(i2);
                            session.getLogger().debug("executing hook " + rHook);
                            hRes = rHook.onHookResult(session, hRes, executionTime, rawHandler);
                        }
                    }
                    if ((response = AbstractHookableCmdHandler.calcDefaultSMTPResponse((HookResult)hRes)) == null) continue;
                    session.writeResponse((Response)response);
                    break;
                }
            }
            finally {
                if (mail != null) {
                    LifecycleUtil.dispose((Object)mail);
                    mail = null;
                }
                session.resetState();
            }
        }
    }

    public void wireExtensions(Class interfaceName, List extension) throws WiringException {
        if (JamesMessageHook.class.equals((Object)interfaceName)) {
            this.messageHandlers = extension;
            if (this.messageHandlers == null || this.messageHandlers.size() == 0) {
                throw new WiringException("No messageHandler configured");
            }
        } else if (MessageHook.class.equals((Object)interfaceName)) {
            this.mHandlers = extension;
        } else if (HookResultHook.class.equals((Object)interfaceName)) {
            this.rHooks = extension;
        }
    }

    public List<Class<?>> getMarkerInterfaces() {
        LinkedList classes = new LinkedList();
        classes.add(JamesMessageHook.class);
        classes.add(MessageHook.class);
        classes.add(HookResultHook.class);
        return classes;
    }

    private class MailToMailEnvelopeWrapper
    implements MailEnvelope {
        private Mail mail;
        private OutputStream out;

        public MailToMailEnvelopeWrapper(Mail mail, OutputStream out) {
            this.mail = mail;
            this.out = out;
        }

        public InputStream getMessageInputStream() throws Exception {
            return this.mail.getMessage().getInputStream();
        }

        public OutputStream getMessageOutputStream() {
            return this.out;
        }

        public List<MailAddress> getRecipients() {
            return new ArrayList<MailAddress>(this.mail.getRecipients());
        }

        public MailAddress getSender() {
            return this.mail.getSender();
        }

        public int getSize() {
            try {
                return (int)this.mail.getMessageSize();
            }
            catch (MessagingException e) {
                return -1;
            }
        }
    }
}

