/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.protocols.api.LifecycleAwareProtocolHandler;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.smtpserver.JamesMessageHook;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;

public class MailPriorityHandler
implements JamesMessageHook,
LifecycleAwareProtocolHandler {
    private Map<String, Integer> prioMap = new HashMap<String, Integer>();

    @Override
    public HookResult onMessage(SMTPSession session, Mail mail) {
        Iterator rcpts = mail.getRecipients().iterator();
        Integer p = null;
        while (rcpts.hasNext()) {
            String domain = ((MailAddress)rcpts.next()).getDomain();
            Integer prio = null;
            if (domain == null || (prio = this.prioMap.get(domain)) == null) continue;
            if (p == null || prio > p) {
                p = prio;
            }
            if (p != 9) continue;
            break;
        }
        if (p != null) {
            mail.setAttribute("MAIL_PRIORITY", p);
        }
        return new HookResult(8);
    }

    public void init(Configuration config) throws ConfigurationException {
        List entries = ((HierarchicalConfiguration)config).configurationsAt("priorityEntries.priorityEntry");
        for (int i = 0; i < entries.size(); ++i) {
            HierarchicalConfiguration prioConf = (HierarchicalConfiguration)entries.get(i);
            String domain = prioConf.getString("domain");
            int prio = prioConf.getInt("priority", 5);
            if (prio > 9 || prio < 0) {
                throw new ConfigurationException("configured priority must be >= 0 and <= 9");
            }
            this.prioMap.put(domain, prio);
        }
    }

    public void destroy() {
    }
}

