/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.james.dnsservice.library.MXHostAddressIterator;
import org.apache.james.lifecycle.api.LogEnabled;
import org.apache.james.protocols.smtp.DNSService;
import org.apache.james.protocols.smtp.TemporaryResolutionException;
import org.apache.mailet.HostAddress;
import org.slf4j.Logger;

public class SMTPServerDNSServiceAdapter
implements DNSService,
LogEnabled {
    private org.apache.james.dnsservice.api.DNSService dns;
    private Logger log;

    public SMTPServerDNSServiceAdapter(org.apache.james.dnsservice.api.DNSService dns) {
        this.dns = dns;
    }

    public Collection<String> findMXRecords(String hostname) throws TemporaryResolutionException {
        try {
            return this.dns.findMXRecords(hostname);
        }
        catch (org.apache.james.dnsservice.api.TemporaryResolutionException e) {
            throw new TemporaryResolutionException(e.getMessage());
        }
    }

    public Collection<String> findTXTRecords(String hostname) {
        return this.dns.findTXTRecords(hostname);
    }

    public InetAddress[] getAllByName(String host) throws UnknownHostException {
        return this.dns.getAllByName(host);
    }

    public InetAddress getByName(String host) throws UnknownHostException {
        return this.dns.getByName(host);
    }

    public String getHostName(InetAddress addr) {
        return this.dns.getHostName(addr);
    }

    public InetAddress getLocalHost() throws UnknownHostException {
        return this.dns.getLocalHost();
    }

    public Iterator<HostAddress> getSMTPHostAddresses(String domainName) throws TemporaryResolutionException {
        return new MXHostAddressIterator(this.findMXRecords(domainName).iterator(), this.dns, false, this.log);
    }

    public void setLog(Logger log) {
        this.log = log;
    }
}

