/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver;

import javax.annotation.Resource;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.AbstractSenderAuthIdentifyVerificationRcptHook;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.smtpserver.netty.SMTPNettySession;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.mailet.MailAddress;

public class SenderAuthIdentifyVerificationRcptHook
extends AbstractSenderAuthIdentifyVerificationRcptHook {
    private DomainList domains;
    private UsersRepository users;

    @Resource(name="usersrepository")
    public final void setUsersRepository(UsersRepository users) {
        this.users = users;
    }

    @Resource(name="domainlist")
    public void setDomainList(DomainList domains) {
        this.domains = domains;
    }

    public HookResult doRcpt(SMTPSession session, MailAddress sender, MailAddress rcpt) {
        SMTPNettySession nSession = (SMTPNettySession)session;
        if (nSession.verifyIdentity()) {
            return super.doRcpt(session, sender, rcpt);
        }
        return new HookResult(8);
    }

    protected boolean isLocalDomain(String domain) {
        try {
            return this.domains.containsDomain(domain);
        }
        catch (DomainListException e) {
            return false;
        }
    }

    protected boolean useVirtualHosting() {
        try {
            return this.users.supportVirtualHosting();
        }
        catch (UsersRepositoryException usersRepositoryException) {
            return false;
        }
    }
}

