/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.fastfail;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.protocols.api.LifecycleAwareProtocolHandler;
import org.apache.james.protocols.smtp.DNSService;
import org.apache.james.smtpserver.SMTPServerDNSServiceAdapter;

public class DNSRBLHandler
extends org.apache.james.protocols.smtp.core.fastfail.DNSRBLHandler
implements LifecycleAwareProtocolHandler {
    @Resource(name="dnsservice")
    public void setDNSService(org.apache.james.dnsservice.api.DNSService dns) {
        super.setDNSService((DNSService)new SMTPServerDNSServiceAdapter(dns));
    }

    public void init(Configuration config) throws ConfigurationException {
        List blackList;
        boolean validConfig = false;
        HierarchicalConfiguration handlerConfiguration = (HierarchicalConfiguration)config;
        ArrayList<String> rblserverCollection = new ArrayList<String>();
        List whiteList = handlerConfiguration.getList("rblservers.whitelist");
        if (whiteList != null) {
            for (int i = 0; i < whiteList.size(); ++i) {
                String rblServerName = (String)whiteList.get(i);
                rblserverCollection.add(rblServerName);
            }
            if (rblserverCollection != null && rblserverCollection.size() > 0) {
                this.setWhitelist(rblserverCollection.toArray(new String[rblserverCollection.size()]));
                rblserverCollection.clear();
                validConfig = true;
            }
        }
        if ((blackList = handlerConfiguration.getList("rblservers.blacklist")) != null) {
            for (int i = 0; i < blackList.size(); ++i) {
                String rblServerName = (String)blackList.get(i);
                rblserverCollection.add(rblServerName);
            }
            if (rblserverCollection != null && rblserverCollection.size() > 0) {
                this.setBlacklist(rblserverCollection.toArray(new String[rblserverCollection.size()]));
                rblserverCollection.clear();
                validConfig = true;
            }
        }
        if (!validConfig) {
            throw new ConfigurationException("Please configure whitelist or blacklist");
        }
        this.setGetDetail(handlerConfiguration.getBoolean("getDetail", false));
    }

    public void destroy() {
    }
}

