/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.fastfail;

import java.io.Serializable;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.jspf.core.DNSService;
import org.apache.james.jspf.executor.SPFResult;
import org.apache.james.jspf.impl.DefaultSPF;
import org.apache.james.jspf.impl.SPF;
import org.apache.james.protocols.api.LifecycleAwareProtocolHandler;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.MailHook;
import org.apache.james.protocols.smtp.hook.RcptHook;
import org.apache.james.smtpserver.JamesMessageHook;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPFHandler
implements JamesMessageHook,
MailHook,
RcptHook,
LifecycleAwareProtocolHandler {
    private static final Logger FALLBACK_LOG = LoggerFactory.getLogger(SPFHandler.class);
    private Logger serviceLog = FALLBACK_LOG;
    public static final String SPF_BLOCKLISTED = "SPF_BLOCKLISTED";
    public static final String SPF_DETAIL = "SPF_DETAIL";
    public static final String SPF_TEMPBLOCKLISTED = "SPF_TEMPBLOCKLISTED";
    public static final String SPF_HEADER = "SPF_HEADER";
    public static final String SPF_HEADER_MAIL_ATTRIBUTE_NAME = "org.apache.james.spf.header";
    private boolean blockSoftFail = false;
    private boolean blockPermError = true;
    private SPF spf = new DefaultSPF((org.apache.james.jspf.core.Logger)new SPFLogger());

    public void setBlockSoftFail(boolean blockSoftFail) {
        this.blockSoftFail = blockSoftFail;
    }

    public void setBlockPermError(boolean blockPermError) {
        this.blockPermError = blockPermError;
    }

    public void setDNSService(DNSService dnsService) {
        this.spf = new SPF(dnsService, (org.apache.james.jspf.core.Logger)new SPFLogger());
    }

    private void doSPFCheck(SMTPSession session, MailAddress sender) {
        String heloEhlo = (String)session.getState().get("CURRENT_HELO_NAME");
        if (sender == null || heloEhlo == null) {
            session.getLogger().info("No Sender or HELO/EHLO present");
        } else {
            String ip = session.getRemoteIPAddress();
            SPFResult result = this.spf.checkSPF(ip, sender.toString(), heloEhlo);
            String spfResult = result.getResult();
            String explanation = "Blocked - see: " + result.getExplanation();
            session.getState().put(SPF_HEADER, result.getHeaderText());
            session.getLogger().info("Result for " + ip + " - " + sender + " - " + heloEhlo + " = " + spfResult);
            if (spfResult.equals("fail") || spfResult.equals("softfail") && this.blockSoftFail || spfResult.equals("permerror") && this.blockPermError) {
                if (spfResult.equals("permerror")) {
                    explanation = "Block caused by an invalid SPF record";
                }
                session.getState().put(SPF_DETAIL, explanation);
                session.getState().put(SPF_BLOCKLISTED, "true");
            } else if (spfResult.equals("temperror")) {
                session.getState().put(SPF_TEMPBLOCKLISTED, "true");
            }
        }
    }

    public HookResult doRcpt(SMTPSession session, MailAddress sender, MailAddress rcpt) {
        if (!session.isRelayingAllowed()) {
            if (session.getState().get(SPF_BLOCKLISTED) != null) {
                return new HookResult(2, DSNStatus.getStatus((int)5, (String)"7.1") + " " + session.getState().get(SPF_TEMPBLOCKLISTED));
            }
            if (session.getState().get(SPF_TEMPBLOCKLISTED) != null) {
                return new HookResult(4, "451", (CharSequence)(DSNStatus.getStatus((int)4, (String)"4.3") + " " + "Temporarily rejected: Problem on SPF lookup"));
            }
        }
        return new HookResult(8);
    }

    public HookResult doMail(SMTPSession session, MailAddress sender) {
        this.doSPFCheck(session, sender);
        return new HookResult(8);
    }

    @Override
    public HookResult onMessage(SMTPSession session, Mail mail) {
        mail.setAttribute(SPF_HEADER_MAIL_ATTRIBUTE_NAME, (Serializable)((Object)((String)session.getState().get(SPF_HEADER))));
        return null;
    }

    public void init(Configuration config) throws ConfigurationException {
        this.setBlockSoftFail(config.getBoolean("blockSoftFail", false));
        this.setBlockPermError(config.getBoolean("blockPermError", true));
    }

    public void destroy() {
    }

    private final class SPFLogger
    implements org.apache.james.jspf.core.Logger {
        private SPFLogger() {
        }

        public void debug(String message) {
            SPFHandler.this.serviceLog.debug(message);
        }

        public void debug(String message, Throwable t) {
            SPFHandler.this.serviceLog.debug(message, t);
        }

        public void error(String message) {
            SPFHandler.this.serviceLog.error(message);
        }

        public void error(String message, Throwable t) {
            SPFHandler.this.serviceLog.error(message, t);
        }

        public void fatalError(String message) {
            SPFHandler.this.serviceLog.error(message);
        }

        public void fatalError(String message, Throwable t) {
            SPFHandler.this.serviceLog.error(message, t);
        }

        public void info(String message) {
            SPFHandler.this.serviceLog.info(message);
        }

        public void info(String message, Throwable t) {
            SPFHandler.this.serviceLog.info(message, t);
        }

        public boolean isDebugEnabled() {
            return SPFHandler.this.serviceLog.isDebugEnabled();
        }

        public boolean isErrorEnabled() {
            return SPFHandler.this.serviceLog.isErrorEnabled();
        }

        public boolean isFatalErrorEnabled() {
            return SPFHandler.this.serviceLog.isErrorEnabled();
        }

        public boolean isInfoEnabled() {
            return SPFHandler.this.serviceLog.isInfoEnabled();
        }

        public boolean isWarnEnabled() {
            return SPFHandler.this.serviceLog.isWarnEnabled();
        }

        public void warn(String message) {
            SPFHandler.this.serviceLog.warn(message);
        }

        public void warn(String message, Throwable t) {
            SPFHandler.this.serviceLog.warn(message, t);
        }

        public org.apache.james.jspf.core.Logger getChildLogger(String name) {
            return this;
        }
    }
}

