/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.fastfail;

import java.io.Serializable;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.protocols.api.LifecycleAwareProtocolHandler;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.smtpserver.JamesMessageHook;
import org.apache.james.util.scanner.SpamAssassinInvoker;
import org.apache.mailet.Mail;

public class SpamAssassinHandler
implements JamesMessageHook,
LifecycleAwareProtocolHandler {
    private int spamdPort = 783;
    private String spamdHost = "localhost";
    private double spamdRejectionHits = 0.0;

    public void setSpamdHost(String spamdHost) {
        this.spamdHost = spamdHost;
    }

    public void setSpamdPort(int spamdPort) {
        this.spamdPort = spamdPort;
    }

    public void setSpamdRejectionHits(double spamdRejectionHits) {
        this.spamdRejectionHits = spamdRejectionHits;
    }

    @Override
    public HookResult onMessage(SMTPSession session, Mail mail) {
        block6: {
            try {
                MimeMessage message = mail.getMessage();
                SpamAssassinInvoker sa = new SpamAssassinInvoker(this.spamdHost, this.spamdPort);
                sa.scanMail(message);
                for (String key : sa.getHeadersAsAttribute().keySet()) {
                    mail.setAttribute(key, (Serializable)((Object)((String)sa.getHeadersAsAttribute().get(key))));
                }
                if (!(this.spamdRejectionHits > 0.0)) break block6;
                try {
                    double hits = Double.parseDouble(sa.getHits());
                    if (this.spamdRejectionHits <= hits) {
                        StringBuffer buffer = new StringBuffer(256).append("Rejected message from ").append(session.getState().get("SENDER_ADDRESS").toString()).append(" from host ").append(session.getRemoteHost()).append(" (").append(session.getRemoteIPAddress()).append(") This message reach the spam hits treshold. Required rejection hits: ").append(this.spamdRejectionHits).append(" hits: ").append(hits);
                        session.getLogger().info(buffer.toString());
                        return new HookResult(2, DSNStatus.getStatus((int)5, (String)"7.0") + " This message reach the spam hits treshold. Please contact the Postmaster if the email is not SPAM. Message rejected");
                    }
                }
                catch (NumberFormatException e) {}
            }
            catch (MessagingException e) {
                session.getLogger().error(e.getMessage());
            }
        }
        return new HookResult(8);
    }

    public void init(Configuration config) throws ConfigurationException {
        this.setSpamdHost(config.getString("spamdHost", "localhost"));
        this.setSpamdPort(config.getInt("spamdPort", 783));
        this.setSpamdRejectionHits(config.getDouble("spamdRejectionHits", 0.0));
    }

    public void destroy() {
    }
}

