/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.fastfail;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.annotation.Resource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.protocols.api.LifecycleAwareProtocolHandler;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.smtpserver.JamesMessageHook;
import org.apache.james.smtpserver.fastfail.URIScanner;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URIRBLHandler
implements JamesMessageHook,
LifecycleAwareProtocolHandler {
    private static final Logger FALLBACK_LOG = LoggerFactory.getLogger(URIRBLHandler.class);
    private Logger serviceLog = FALLBACK_LOG;
    private static final String LISTED_DOMAIN = "LISTED_DOMAIN";
    private static final String URBLSERVER = "URBL_SERVER";
    private DNSService dnsService;
    private Collection<String> uriRbl;
    private boolean getDetail = false;

    public final DNSService getDNSService() {
        return this.dnsService;
    }

    @Resource(name="dnsservice")
    public final void setDNSService(DNSService dnsService) {
        this.dnsService = dnsService;
    }

    public void setUriRblServer(Collection<String> uriRbl) {
        this.uriRbl = uriRbl;
    }

    public void setGetDetail(boolean getDetail) {
        this.getDetail = getDetail;
    }

    @Override
    public HookResult onMessage(SMTPSession session, Mail mail) {
        if (this.check(session, mail)) {
            Collection txt;
            String uRblServer = (String)session.getState().get(URBLSERVER);
            String target = (String)session.getState().get(LISTED_DOMAIN);
            String detail = null;
            if (this.getDetail && !(txt = this.dnsService.findTXTRecords(target + "." + uRblServer)).isEmpty()) {
                detail = (String)txt.iterator().next();
            }
            if (detail != null) {
                return new HookResult(2, DSNStatus.getStatus((int)5, (String)"7.0") + "Rejected: message contains domain " + target + " listed by " + uRblServer + " . Details: " + detail);
            }
            return new HookResult(2, DSNStatus.getStatus((int)5, (String)"7.0") + " Rejected: message contains domain " + target + " listed by " + uRblServer);
        }
        return new HookResult(8);
    }

    private HashSet<String> scanMailForDomains(MimePart part, SMTPSession session) throws MessagingException, IOException {
        HashSet<String> domains = new HashSet<String>();
        session.getLogger().debug("mime type is: \"" + part.getContentType() + "\"");
        if (part.isMimeType("text/plain") || part.isMimeType("text/html")) {
            session.getLogger().debug("scanning: \"" + part.getContent().toString() + "\"");
            HashSet<String> newDom = URIScanner.scanContentForDomains(domains, part.getContent().toString());
            if (newDom != null && newDom.size() > 0) {
                domains.addAll(newDom);
            }
        } else if (part.isMimeType("multipart/*")) {
            MimeMultipart multipart = (MimeMultipart)part.getContent();
            int count = multipart.getCount();
            session.getLogger().debug("multipart count is: " + count);
            for (int index = 0; index < count; ++index) {
                session.getLogger().debug("recursing index: " + index);
                MimeBodyPart mimeBodyPart = (MimeBodyPart)multipart.getBodyPart(index);
                HashSet<String> newDomains = this.scanMailForDomains((MimePart)mimeBodyPart, session);
                if (newDomains == null || newDomains.size() <= 0) continue;
                domains.addAll(newDomains);
            }
        }
        return domains;
    }

    protected boolean check(SMTPSession session, Mail mail) {
        try {
            MimeMessage message = mail.getMessage();
            HashSet<String> domains = this.scanMailForDomains((MimePart)message, session);
            Iterator<String> fDomains = domains.iterator();
            while (fDomains.hasNext()) {
                Iterator<String> uRbl = this.uriRbl.iterator();
                String target = fDomains.next().toString();
                while (uRbl.hasNext()) {
                    try {
                        String uRblServer = uRbl.next().toString();
                        String address = target + "." + uRblServer;
                        if (session.getLogger().isDebugEnabled()) {
                            session.getLogger().debug("Lookup " + address);
                        }
                        this.dnsService.getByName(address);
                        session.getState().put(URBLSERVER, uRblServer);
                        session.getState().put(LISTED_DOMAIN, target);
                        return true;
                    }
                    catch (UnknownHostException uhe) {
                    }
                }
            }
        }
        catch (MessagingException e) {
            session.getLogger().error(e.getMessage());
        }
        catch (IOException e) {
            session.getLogger().error(e.getMessage());
        }
        return false;
    }

    public void init(Configuration config) throws ConfigurationException {
        String[] servers = config.getStringArray("uriRblServers.server");
        ArrayList<String> serverCollection = new ArrayList<String>();
        for (int i = 0; i < servers.length; ++i) {
            String rblServerName = servers[i];
            serverCollection.add(rblServerName);
            if (!this.serviceLog.isInfoEnabled()) continue;
            this.serviceLog.info("Adding uriRBL server: " + rblServerName);
        }
        if (serverCollection == null || serverCollection.size() <= 0) {
            throw new ConfigurationException("Please provide at least one server");
        }
        this.setUriRblServer(serverCollection);
        this.setGetDetail(config.getBoolean("getDetail", false));
    }

    public void destroy() {
    }
}

