/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.fastfail;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.dnsservice.api.TemporaryResolutionException;
import org.apache.james.dnsservice.library.netmatcher.NetMatcher;
import org.apache.james.protocols.api.LifecycleAwareProtocolHandler;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.RcptHook;
import org.apache.mailet.MailAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidRcptMX
implements LifecycleAwareProtocolHandler,
RcptHook {
    private static final Logger FALLBACK_LOG = LoggerFactory.getLogger(ValidRcptMX.class);
    private Logger serviceLog = FALLBACK_LOG;
    private DNSService dnsService = null;
    private static final String LOCALHOST = "localhost";
    private NetMatcher bNetwork = null;

    public void setLog(Logger log) {
        this.serviceLog = log;
    }

    public final DNSService getDNSService() {
        return this.dnsService;
    }

    @Resource(name="dnsservice")
    public final void setDNSService(DNSService dnsService) {
        this.dnsService = dnsService;
    }

    public void setBannedNetworks(Collection<String> networks, DNSService dnsServer) {
        this.bNetwork = new NetMatcher(networks, dnsServer){

            protected void log(String s) {
                ValidRcptMX.this.serviceLog.debug(s);
            }
        };
    }

    public HookResult doRcpt(SMTPSession session, MailAddress sender, MailAddress rcpt) {
        String domain = rcpt.getDomain();
        if (!domain.equals(LOCALHOST)) {
            Iterator mx = null;
            try {
                mx = this.dnsService.findMXRecords(domain).iterator();
            }
            catch (TemporaryResolutionException e1) {
                return new HookResult(4);
            }
            if (mx != null && mx.hasNext()) {
                while (mx.hasNext()) {
                    String mxRec = (String)mx.next();
                    try {
                        String ip = this.dnsService.getByName(mxRec).getHostAddress();
                        if (!this.bNetwork.matchInetNetwork(ip)) continue;
                        return new HookResult(2, "530", (CharSequence)(DSNStatus.getStatus((int)5, (String)"7.1") + " Invalid MX " + session.getRemoteIPAddress() + " for domain " + domain + ". Reject email"));
                    }
                    catch (UnknownHostException e) {
                    }
                }
            }
        }
        return new HookResult(8);
    }

    public void init(Configuration config) throws ConfigurationException {
        ArrayList<String> bannedNetworks;
        List networks = config.getList("invalidMXNetworks");
        if (!networks.isEmpty()) {
            bannedNetworks = new ArrayList<String>();
            for (int i = 0; i < networks.size(); ++i) {
                String network = (String)networks.get(i);
                bannedNetworks.add(network.trim());
            }
        } else {
            throw new ConfigurationException("Please configure at least on invalid MX network");
        }
        this.setBannedNetworks(bannedNetworks, this.dnsService);
        this.serviceLog.info("Invalid MX Networks: " + this.bNetwork.toString());
    }

    public void destroy() {
    }
}

