/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.jmx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.protocols.api.ExtensibleHandler;
import org.apache.james.protocols.api.LifecycleAwareProtocolHandler;
import org.apache.james.protocols.api.WiringException;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.Hook;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookResultHook;
import org.apache.james.smtpserver.jmx.HookStats;

public class HookResultJMXMonitor
implements HookResultHook,
ExtensibleHandler,
LifecycleAwareProtocolHandler {
    private Map<String, HookStats> hookStats = new HashMap<String, HookStats>();
    private String jmxPath;

    public HookResult onHookResult(SMTPSession session, HookResult result, long executionTime, Hook hook) {
        String hookName = hook.getClass().getName();
        HookStats stats = this.hookStats.get(hookName);
        if (stats != null) {
            stats.increment(result.getResult());
        }
        return result;
    }

    public List<Class<?>> getMarkerInterfaces() {
        ArrayList marker = new ArrayList();
        marker.add(Hook.class);
        return marker;
    }

    public void wireExtensions(Class<?> interfaceName, List<?> extension) throws WiringException {
        if (interfaceName.equals(Hook.class)) {
            for (int i = 0; i < extension.size(); ++i) {
                Object hook = extension.get(i);
                if (this.equals(hook)) continue;
                String hookName = hook.getClass().getName();
                try {
                    this.hookStats.put(hookName, new HookStats(this.jmxPath, hookName));
                    continue;
                }
                catch (Exception e) {
                    throw new WiringException("Unable to wire Hooks", (Throwable)e);
                }
            }
        }
    }

    protected String getDefaultJMXName() {
        return "smtpserver";
    }

    public void init(Configuration config) throws ConfigurationException {
        this.jmxPath = config.getString("jmxName", this.getDefaultJMXName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Map<String, HookStats> map = this.hookStats;
        synchronized (map) {
            Iterator<HookStats> stats = this.hookStats.values().iterator();
            while (stats.hasNext()) {
                stats.next().dispose();
            }
            this.hookStats.clear();
        }
    }
}

