/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.netty;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.protocols.api.ProtocolHandlerChain;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.impl.AbstractChannelUpstreamHandler;
import org.apache.james.protocols.smtp.SMTPConfiguration;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.smtpserver.netty.SMTPNettySession;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.slf4j.Logger;

public class SMTPChannelUpstreamHandler
extends AbstractChannelUpstreamHandler {
    private final Logger logger;
    private final SMTPConfiguration conf;
    private final SSLContext context;
    private String[] enabledCipherSuites;

    public SMTPChannelUpstreamHandler(ProtocolHandlerChain chain, SMTPConfiguration conf, Logger logger) {
        this(chain, conf, logger, null, null);
    }

    public SMTPChannelUpstreamHandler(ProtocolHandlerChain chain, SMTPConfiguration conf, Logger logger, SSLContext context, String[] enabledCipherSuites) {
        super(chain);
        this.conf = conf;
        this.logger = logger;
        this.context = context;
        this.enabledCipherSuites = enabledCipherSuites;
    }

    protected ProtocolSession createSession(ChannelHandlerContext ctx) throws Exception {
        if (this.context != null) {
            SSLEngine engine = this.context.createSSLEngine();
            if (this.enabledCipherSuites != null && this.enabledCipherSuites.length > 0) {
                engine.setEnabledCipherSuites(this.enabledCipherSuites);
            }
            return new SMTPNettySession(this.conf, this.logger, ctx, engine);
        }
        return new SMTPNettySession(this.conf, this.logger, ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Channel channel = ctx.getChannel();
        if (e.getCause() instanceof TooLongFrameException) {
            ctx.getChannel().write((Object)new SMTPResponse("500", (CharSequence)"Line length exceeded. See RFC 2821 #4.5.3.1."));
        } else {
            if (channel.isConnected()) {
                ctx.getChannel().write((Object)new SMTPResponse("451", (CharSequence)"Unable to process request"));
            }
            this.logger.debug("Unable to process request", e.getCause());
            this.cleanup(channel);
            channel.close();
        }
        super.exceptionCaught(ctx, e);
    }

    protected void cleanup(Channel channel) {
        SMTPSession smtpSession = (SMTPSession)attributes.get(channel);
        if (smtpSession != null) {
            LifecycleUtil.dispose(smtpSession.getState().get("MAIL"));
            LifecycleUtil.dispose(smtpSession.getState().get("org.apache.james.core.DataCmdHandler.DATA_MIMEMESSAGE_STREAMSOURCE"));
        }
        super.cleanup(channel);
    }
}

