/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.netty;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import org.apache.james.protocols.api.LineHandler;
import org.apache.james.protocols.impl.AbstractSession;
import org.apache.james.protocols.impl.LineHandlerUpstreamHandler;
import org.apache.james.protocols.smtp.SMTPConfiguration;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.smtpserver.netty.SMTPServer;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;

public class SMTPNettySession
extends AbstractSession
implements SMTPSession {
    public static final String SMTP_SESSION = "SMTP_SESSION";
    private boolean relayingAllowed;
    private Map<String, Object> connectionState;
    private SMTPConfiguration theConfigData;
    private int lineHandlerCount = 0;

    public SMTPNettySession(SMTPConfiguration theConfigData, Logger logger, ChannelHandlerContext handlerContext, SSLEngine engine) {
        super(logger, handlerContext, engine);
        this.theConfigData = theConfigData;
        this.connectionState = new HashMap<String, Object>();
        this.relayingAllowed = theConfigData.isRelayingAllowed(this.getRemoteIPAddress());
    }

    public SMTPNettySession(SMTPConfiguration theConfigData, Logger logger, ChannelHandlerContext handlerContext) {
        this(theConfigData, logger, handlerContext, null);
    }

    public Map<String, Object> getConnectionState() {
        return this.connectionState;
    }

    public Map<String, Object> getState() {
        HashMap res = (HashMap)this.getConnectionState().get("SESSION_STATE_MAP");
        if (res == null) {
            res = new HashMap();
            this.getConnectionState().put("SESSION_STATE_MAP", res);
        }
        return res;
    }

    public boolean isRelayingAllowed() {
        return this.relayingAllowed;
    }

    public void resetState() {
        Object currentHeloMode = this.getState().get("CURRENT_HELO_MODE");
        this.getState().clear();
        if (currentHeloMode != null) {
            this.getState().put("CURRENT_HELO_MODE", currentHeloMode);
        }
    }

    public void popLineHandler() {
        if (this.lineHandlerCount > 0) {
            this.getChannelHandlerContext().getPipeline().remove("lineHandler" + this.lineHandlerCount);
            --this.lineHandlerCount;
        }
    }

    public void pushLineHandler(LineHandler<SMTPSession> overrideCommandHandler) {
        ++this.lineHandlerCount;
        this.getChannelHandlerContext().getPipeline().addBefore("coreHandler", "lineHandler" + this.lineHandlerCount, (ChannelHandler)new LineHandlerUpstreamHandler(overrideCommandHandler));
    }

    public String getHelloName() {
        return this.theConfigData.getHelloName();
    }

    public long getMaxMessageSize() {
        return this.theConfigData.getMaxMessageSize();
    }

    public int getRcptCount() {
        int count = 0;
        if (this.getState().get("RCPT_LIST") != null) {
            count = ((Collection)this.getState().get("RCPT_LIST")).size();
        }
        return count;
    }

    public String getSMTPGreeting() {
        return this.theConfigData.getSMTPGreeting();
    }

    public boolean isAuthSupported() {
        return this.theConfigData.isAuthRequired(this.socketAddress.getAddress().getHostAddress());
    }

    public void setRelayingAllowed(boolean relayingAllowed) {
        this.relayingAllowed = relayingAllowed;
    }

    public void sleep(long ms) {
    }

    public boolean useAddressBracketsEnforcement() {
        return this.theConfigData.useAddressBracketsEnforcement();
    }

    public boolean useHeloEhloEnforcement() {
        return this.theConfigData.useHeloEhloEnforcement();
    }

    public int getPushedLineHandlerCount() {
        return this.lineHandlerCount;
    }

    public boolean verifyIdentity() {
        if (this.theConfigData instanceof SMTPServer.SMTPHandlerConfigurationDataImpl) {
            return ((SMTPServer.SMTPHandlerConfigurationDataImpl)this.theConfigData).verifyIdentity();
        }
        return true;
    }
}

