/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.netty;

import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.annotation.Resource;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.dnsservice.library.netmatcher.NetMatcher;
import org.apache.james.protocols.api.HandlersPackage;
import org.apache.james.protocols.lib.netty.AbstractProtocolAsyncServer;
import org.apache.james.protocols.smtp.SMTPConfiguration;
import org.apache.james.smtpserver.CoreCmdHandlerLoader;
import org.apache.james.smtpserver.jmx.JMXHandlersLoader;
import org.apache.james.smtpserver.netty.SMTPChannelUpstreamHandler;
import org.apache.james.smtpserver.netty.SMTPResponseEncoder;
import org.apache.james.smtpserver.netty.SMTPServerMBean;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;

public class SMTPServer
extends AbstractProtocolAsyncServer
implements SMTPServerMBean {
    private static final int AUTH_DISABLED = 0;
    private static final int AUTH_REQUIRED = 1;
    private static final int AUTH_ANNOUNCE = 2;
    private int authRequired = 0;
    private boolean heloEhloEnforcement = false;
    private String smtpGreeting = null;
    private NetMatcher authorizedNetworks = null;
    private long maxMessageSize = 0L;
    private int lengthReset = 20480;
    private final SMTPConfiguration theConfigData = new SMTPHandlerConfigurationDataImpl();
    private boolean addressBracketsEnforcement = true;
    private boolean verifyIdentity;
    private DNSService dns;
    private String authorizedAddresses;

    @Resource(name="dnsservice")
    public void setDNSService(DNSService dns) {
        this.dns = dns;
    }

    protected void preInit() throws Exception {
        if (this.authorizedAddresses != null) {
            StringTokenizer st = new StringTokenizer(this.authorizedAddresses, ", ", false);
            ArrayList<String> networks = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                String addr = st.nextToken();
                networks.add(addr);
            }
            this.authorizedNetworks = new NetMatcher(networks, this.dns);
        }
        super.preInit();
    }

    public void doConfigure(HierarchicalConfiguration configuration) throws ConfigurationException {
        super.doConfigure(configuration);
        if (this.isEnabled()) {
            String authRequiredString = configuration.getString("authRequired", "false").trim().toLowerCase();
            this.authRequired = authRequiredString.equals("true") ? 1 : (authRequiredString.equals("announce") ? 2 : 0);
            if (this.authRequired != 0) {
                this.getLogger().info("This SMTP server requires authentication.");
            } else {
                this.getLogger().info("This SMTP server does not require authentication.");
            }
            this.authorizedAddresses = configuration.getString("authorizedAddresses", null);
            if (this.authRequired == 0 && this.authorizedAddresses == null) {
                this.authorizedAddresses = "0.0.0.0/0.0.0.0";
            }
            if (this.authorizedNetworks != null) {
                this.getLogger().info("Authorized addresses: " + this.authorizedNetworks.toString());
            }
            this.maxMessageSize = configuration.getLong("maxmessagesize", this.maxMessageSize) * 1024L;
            if (this.maxMessageSize > 0L) {
                this.getLogger().info("The maximum allowed message size is " + this.maxMessageSize + " bytes.");
            } else {
                this.getLogger().info("No maximum message size is enforced for this server.");
            }
            this.heloEhloEnforcement = configuration.getBoolean("heloEhloEnforcement", true);
            if (authRequiredString.equals("true")) {
                this.authRequired = 1;
            }
            this.smtpGreeting = configuration.getString("smtpGreeting", null);
            this.addressBracketsEnforcement = configuration.getBoolean("addressBracketsEnforcement", true);
            this.verifyIdentity = configuration.getBoolean("verifyIdentity", true);
        }
    }

    protected int getDefaultPort() {
        return 25;
    }

    public String getServiceType() {
        return "SMTP Service";
    }

    @Override
    public long getMaximalMessageSize() {
        return this.maxMessageSize;
    }

    @Override
    public boolean getAddressBracketsEnforcement() {
        return this.addressBracketsEnforcement;
    }

    @Override
    public boolean getHeloEhloEnforcement() {
        return this.heloEhloEnforcement;
    }

    protected String getDefaultJMXName() {
        return "smtpserver";
    }

    @Override
    public void setMaximalMessageSize(long maxSize) {
        this.maxMessageSize = maxSize;
    }

    @Override
    public void setAddressBracketsEnforcement(boolean enforceAddressBrackets) {
        this.addressBracketsEnforcement = enforceAddressBrackets;
    }

    @Override
    public void setHeloEhloEnforcement(boolean enforceHeloEHlo) {
        this.heloEhloEnforcement = enforceHeloEHlo;
    }

    @Override
    public String getHeloName() {
        return this.theConfigData.getHelloName();
    }

    protected ChannelUpstreamHandler createCoreHandler() {
        return new SMTPChannelUpstreamHandler(this.getProtocolHandlerChain(), this.theConfigData, this.getLogger(), this.getSSLContext(), this.getEnabledCipherSuites());
    }

    protected OneToOneEncoder createEncoder() {
        return new SMTPResponseEncoder();
    }

    protected Class<? extends HandlersPackage> getCoreHandlersPackage() {
        return CoreCmdHandlerLoader.class;
    }

    protected Class<? extends HandlersPackage> getJMXHandlersPackage() {
        return JMXHandlersLoader.class;
    }

    public class SMTPHandlerConfigurationDataImpl
    implements SMTPConfiguration {
        public String getHelloName() {
            return SMTPServer.this.getHelloName();
        }

        public int getResetLength() {
            return SMTPServer.this.lengthReset;
        }

        public long getMaxMessageSize() {
            return SMTPServer.this.maxMessageSize;
        }

        public boolean isRelayingAllowed(String remoteIP) {
            boolean relayingAllowed = false;
            if (SMTPServer.this.authorizedNetworks != null) {
                relayingAllowed = SMTPServer.this.authorizedNetworks.matchInetNetwork(remoteIP);
            }
            return relayingAllowed;
        }

        public boolean useHeloEhloEnforcement() {
            return SMTPServer.this.heloEhloEnforcement;
        }

        public String getSMTPGreeting() {
            return SMTPServer.this.smtpGreeting;
        }

        public boolean useAddressBracketsEnforcement() {
            return SMTPServer.this.addressBracketsEnforcement;
        }

        public boolean isAuthRequired(String remoteIP) {
            boolean authRequired;
            if (SMTPServer.this.authRequired == 2) {
                return true;
            }
            boolean bl = authRequired = SMTPServer.this.authRequired != 0;
            if (SMTPServer.this.authorizedNetworks != null) {
                authRequired = authRequired && !SMTPServer.this.authorizedNetworks.matchInetNetwork(remoteIP);
            }
            return authRequired;
        }

        public boolean isStartTLSSupported() {
            return SMTPServer.this.isStartTLSSupported();
        }

        public boolean verifyIdentity() {
            return SMTPServer.this.verifyIdentity;
        }
    }
}

