/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.jdbc;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.lib.AbstractRecipientRewriteTable;
import org.apache.james.rrt.lib.RecipientRewriteTableUtil;
import org.apache.james.util.sql.JDBCUtil;
import org.apache.james.util.sql.SqlResources;

@Deprecated
public class JDBCRecipientRewriteTable
extends AbstractRecipientRewriteTable {
    private DataSource dataSource = null;
    private String dataSourceName = null;
    private String tableName = "RecipientRewriteTable";
    private SqlResources sqlQueries;
    private String sqlFileName;
    private FileSystem fileSystem;
    private final JDBCUtil theJDBCUtil = new JDBCUtil(){

        protected void delegatedLog(String logString) {
            JDBCRecipientRewriteTable.this.getLogger().debug("JDBCRecipientRewriteTable: " + logString);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() throws Exception {
        StringBuffer logBuffer = null;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(((Object)((Object)this)).getClass().getName() + ".initialize()");
        }
        Connection conn = this.dataSource.getConnection();
        PreparedStatement createStatement = null;
        try {
            InputStream sqlFile = null;
            try {
                sqlFile = this.fileSystem.getResource(this.sqlFileName);
            }
            catch (Exception e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
                throw e;
            }
            if (this.getLogger().isDebugEnabled()) {
                logBuffer = new StringBuffer(128).append("Reading SQL resources from file: ").append(this.sqlFileName).append(", section ").append(((Object)((Object)this)).getClass().getName()).append(".");
                this.getLogger().debug(logBuffer.toString());
            }
            HashMap<String, String> sqlParameters = new HashMap<String, String>();
            if (this.tableName != null) {
                sqlParameters.put("table", this.tableName);
            }
            this.sqlQueries = new SqlResources();
            this.sqlQueries.init(sqlFile, ((Object)((Object)this)).getClass().getName(), conn, sqlParameters);
            DatabaseMetaData dbMetaData = conn.getMetaData();
            if (!this.theJDBCUtil.tableExists(dbMetaData, this.tableName)) {
                createStatement = conn.prepareStatement(this.sqlQueries.getSqlString("createTable", true));
                createStatement.execute();
                if (this.getLogger().isInfoEnabled()) {
                    logBuffer = new StringBuffer(64).append("JdbcVirtalUserTable: Created table '").append(this.tableName).append("'.");
                    this.getLogger().info(logBuffer.toString());
                }
            }
        }
        finally {
            this.theJDBCUtil.closeJDBCStatement(createStatement);
            this.theJDBCUtil.closeJDBCConnection(conn);
        }
    }

    @Resource(name="filesystem")
    public void setFileSystem(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    @Resource(name="datasource")
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected void doConfigure(HierarchicalConfiguration conf) throws ConfigurationException {
        String destination = conf.getString("[@destinationURL]", null);
        if (destination == null) {
            throw new ConfigurationException("destinationURL must configured");
        }
        if (!destination.endsWith("/")) {
            destination = destination + "/";
        }
        ArrayList<String> urlParams = new ArrayList<String>();
        int start = 5;
        int end = destination.indexOf(47, start);
        while (end > -1) {
            urlParams.add(destination.substring(start, end));
            start = end + 1;
            end = destination.indexOf(47, start);
        }
        if (urlParams.size() == 0) {
            StringBuffer exceptionBuffer = new StringBuffer(256).append("Malformed destinationURL - Must be of the format '").append("db://<data-source>'.  Was passed ").append(conf.getString("[@destinationURL]"));
            throw new ConfigurationException(exceptionBuffer.toString());
        }
        if (urlParams.size() >= 1) {
            this.dataSourceName = (String)urlParams.get(0);
        }
        if (urlParams.size() >= 2) {
            this.tableName = (String)urlParams.get(1);
        }
        if (this.getLogger().isDebugEnabled()) {
            StringBuffer logBuffer = new StringBuffer(128).append("Parsed URL: table = '").append(this.tableName).append("'");
            this.getLogger().debug(logBuffer.toString());
        }
        this.sqlFileName = conf.getString("sqlFile");
    }

    protected void addMappingInternal(String user, String domain, String regex) throws RecipientRewriteTableException {
        String newDomain;
        String newUser = this.getUserString(user);
        Collection map = this.getUserDomainMappings(newUser, newDomain = this.getDomainString(domain));
        if (map != null && map.size() != 0) {
            map.add(regex);
            this.updateMapping(newUser, newDomain, RecipientRewriteTableUtil.CollectionToMapping((Collection)map));
        }
        this.addRawMapping(newUser, newDomain, regex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected String mapAddressInternal(String user, String domain) throws RecipientRewriteTableException {
        PreparedStatement mappingStmt;
        Connection conn;
        block8: {
            ResultSet mappingRS;
            block7: {
                conn = null;
                mappingStmt = null;
                conn = this.dataSource.getConnection();
                mappingStmt = conn.prepareStatement(this.sqlQueries.getSqlString("selectMappings", true));
                mappingRS = null;
                mappingStmt.setString(1, user);
                mappingStmt.setString(2, domain);
                mappingRS = mappingStmt.executeQuery();
                if (!mappingRS.next()) break block7;
                String string = mappingRS.getString(1);
                this.theJDBCUtil.closeJDBCResultSet(mappingRS);
                this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
                this.theJDBCUtil.closeJDBCConnection(conn);
                return string;
            }
            try {
                this.theJDBCUtil.closeJDBCResultSet(mappingRS);
                break block8;
                {
                    catch (Throwable throwable) {
                        this.theJDBCUtil.closeJDBCResultSet(mappingRS);
                        throw throwable;
                    }
                }
            }
            catch (SQLException sqle) {
                try {
                    this.getLogger().error("Error accessing database", (Throwable)sqle);
                    throw new RecipientRewriteTableException("Error accessing database", (Throwable)sqle);
                }
                catch (Throwable throwable) {
                    this.theJDBCUtil.closeJDBCStatement(mappingStmt);
                    this.theJDBCUtil.closeJDBCConnection(conn);
                    throw throwable;
                }
            }
        }
        this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
        this.theJDBCUtil.closeJDBCConnection(conn);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected Collection<String> getUserDomainMappingsInternal(String user, String domain) throws RecipientRewriteTableException {
        PreparedStatement mappingStmt;
        Connection conn;
        block8: {
            ResultSet mappingRS;
            block7: {
                conn = null;
                mappingStmt = null;
                conn = this.dataSource.getConnection();
                mappingStmt = conn.prepareStatement(this.sqlQueries.getSqlString("selectUserDomainMapping", true));
                mappingRS = null;
                mappingStmt.setString(1, user);
                mappingStmt.setString(2, domain);
                mappingRS = mappingStmt.executeQuery();
                if (!mappingRS.next()) break block7;
                ArrayList arrayList = RecipientRewriteTableUtil.mappingToCollection((String)mappingRS.getString(1));
                this.theJDBCUtil.closeJDBCResultSet(mappingRS);
                this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
                this.theJDBCUtil.closeJDBCConnection(conn);
                return arrayList;
            }
            try {
                this.theJDBCUtil.closeJDBCResultSet(mappingRS);
                break block8;
                {
                    catch (Throwable throwable) {
                        this.theJDBCUtil.closeJDBCResultSet(mappingRS);
                        throw throwable;
                    }
                }
            }
            catch (SQLException sqle) {
                try {
                    this.getLogger().error("Error accessing database", (Throwable)sqle);
                    throw new RecipientRewriteTableException("Error accessing database", (Throwable)sqle);
                }
                catch (Throwable throwable) {
                    this.theJDBCUtil.closeJDBCStatement(mappingStmt);
                    this.theJDBCUtil.closeJDBCConnection(conn);
                    throw throwable;
                }
            }
        }
        this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
        this.theJDBCUtil.closeJDBCConnection(conn);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected Map<String, Collection<String>> getAllMappingsInternal() throws RecipientRewriteTableException {
        PreparedStatement mappingStmt;
        Connection conn;
        block9: {
            ResultSet mappingRS;
            block8: {
                conn = null;
                mappingStmt = null;
                HashMap<String, Collection<String>> mapping = new HashMap<String, Collection<String>>();
                conn = this.dataSource.getConnection();
                mappingStmt = conn.prepareStatement(this.sqlQueries.getSqlString("selectAllMappings", true));
                mappingRS = null;
                mappingRS = mappingStmt.executeQuery();
                while (mappingRS.next()) {
                    String user = mappingRS.getString(1);
                    String domain = mappingRS.getString(2);
                    String map = mappingRS.getString(3);
                    mapping.put(user + "@" + domain, RecipientRewriteTableUtil.mappingToCollection((String)map));
                }
                if (mapping.size() <= 0) break block8;
                HashMap<String, Collection<String>> hashMap = mapping;
                this.theJDBCUtil.closeJDBCResultSet(mappingRS);
                this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
                this.theJDBCUtil.closeJDBCConnection(conn);
                return hashMap;
            }
            try {
                this.theJDBCUtil.closeJDBCResultSet(mappingRS);
                break block9;
                {
                    catch (Throwable throwable) {
                        this.theJDBCUtil.closeJDBCResultSet(mappingRS);
                        throw throwable;
                    }
                }
            }
            catch (SQLException sqle) {
                try {
                    this.getLogger().error("Error accessing database", (Throwable)sqle);
                    throw new RecipientRewriteTableException("Error accessing database", (Throwable)sqle);
                }
                catch (Throwable throwable) {
                    this.theJDBCUtil.closeJDBCStatement(mappingStmt);
                    this.theJDBCUtil.closeJDBCConnection(conn);
                    throw throwable;
                }
            }
        }
        this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
        this.theJDBCUtil.closeJDBCConnection(conn);
        return null;
    }

    protected void removeMappingInternal(String user, String domain, String mapping) throws RecipientRewriteTableException {
        String newDomain;
        String newUser = this.getUserString(user);
        Collection map = this.getUserDomainMappings(newUser, newDomain = this.getDomainString(domain));
        if (map != null && map.size() > 1) {
            map.remove(mapping);
            this.updateMapping(newUser, newDomain, RecipientRewriteTableUtil.CollectionToMapping((Collection)map));
        } else {
            this.removeRawMapping(newUser, newDomain, mapping);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMapping(String user, String domain, String mapping) throws RecipientRewriteTableException {
        Connection conn = null;
        PreparedStatement mappingStmt = null;
        try {
            conn = this.dataSource.getConnection();
            mappingStmt = conn.prepareStatement(this.sqlQueries.getSqlString("updateMapping", true));
            ResultSet mappingRS = null;
            try {
                mappingStmt.setString(1, mapping);
                mappingStmt.setString(2, user);
                mappingStmt.setString(3, domain);
                if (mappingStmt.executeUpdate() < 1) {
                    throw new RecipientRewriteTableException("Mapping not found");
                }
            }
            finally {
                this.theJDBCUtil.closeJDBCResultSet(mappingRS);
            }
        }
        catch (SQLException sqle) {
            try {
                this.getLogger().error("Error accessing database", (Throwable)sqle);
                throw new RecipientRewriteTableException("Error accessing database", (Throwable)sqle);
            }
            catch (Throwable throwable) {
                this.theJDBCUtil.closeJDBCStatement(mappingStmt);
                this.theJDBCUtil.closeJDBCConnection(conn);
                throw throwable;
            }
        }
        this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
        this.theJDBCUtil.closeJDBCConnection(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRawMapping(String user, String domain, String mapping) throws RecipientRewriteTableException {
        Connection conn = null;
        PreparedStatement mappingStmt = null;
        try {
            conn = this.dataSource.getConnection();
            mappingStmt = conn.prepareStatement(this.sqlQueries.getSqlString("deleteMapping", true));
            ResultSet mappingRS = null;
            try {
                mappingStmt.setString(1, user);
                mappingStmt.setString(2, domain);
                mappingStmt.setString(3, mapping);
                if (mappingStmt.executeUpdate() < 1) {
                    throw new RecipientRewriteTableException("Mapping not found");
                }
            }
            finally {
                this.theJDBCUtil.closeJDBCResultSet(mappingRS);
            }
        }
        catch (SQLException sqle) {
            try {
                this.getLogger().error("Error accessing database", (Throwable)sqle);
            }
            catch (Throwable throwable) {
                this.theJDBCUtil.closeJDBCStatement(mappingStmt);
                this.theJDBCUtil.closeJDBCConnection(conn);
                throw throwable;
            }
            this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
            this.theJDBCUtil.closeJDBCConnection(conn);
        }
        this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
        this.theJDBCUtil.closeJDBCConnection(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRawMapping(String user, String domain, String mapping) throws RecipientRewriteTableException {
        Connection conn = null;
        PreparedStatement mappingStmt = null;
        try {
            conn = this.dataSource.getConnection();
            mappingStmt = conn.prepareStatement(this.sqlQueries.getSqlString("addMapping", true));
            ResultSet mappingRS = null;
            try {
                mappingStmt.setString(1, user);
                mappingStmt.setString(2, domain);
                mappingStmt.setString(3, mapping);
                if (mappingStmt.executeUpdate() < 1) {
                    throw new RecipientRewriteTableException("Mapping not found");
                }
            }
            finally {
                this.theJDBCUtil.closeJDBCResultSet(mappingRS);
            }
        }
        catch (SQLException sqle) {
            try {
                this.getLogger().error("Error accessing database", (Throwable)sqle);
            }
            catch (Throwable throwable) {
                this.theJDBCUtil.closeJDBCStatement(mappingStmt);
                this.theJDBCUtil.closeJDBCConnection(conn);
                throw throwable;
            }
            this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
            this.theJDBCUtil.closeJDBCConnection(conn);
        }
        this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
        this.theJDBCUtil.closeJDBCConnection(conn);
    }

    private String getUserString(String user) {
        if (user != null) {
            if (user.equals("*") || user.indexOf("@") < 0) {
                return user;
            }
            throw new IllegalArgumentException("Invalid user: " + user);
        }
        return "*";
    }

    private String getDomainString(String domain) {
        if (domain != null) {
            if (domain.equals("*") || domain.indexOf("@") < 0) {
                return domain;
            }
            throw new IllegalArgumentException("Invalid domain: " + domain);
        }
        return "*";
    }
}

