/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.jdbc;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.api.model.User;
import org.apache.james.user.lib.AbstractJamesUsersRepository;
import org.apache.james.util.sql.JDBCUtil;
import org.apache.james.util.sql.SqlResources;

@Deprecated
public abstract class AbstractJdbcUsersRepository
extends AbstractJamesUsersRepository {
    protected Map<String, String> m_sqlParameters;
    private String m_sqlFileName;
    private String m_datasourceName;
    private DataSource m_datasource;
    private String m_getUsersSql;
    private String m_userByNameCaseInsensitiveSql;
    private String m_insertUserSql;
    private String m_updateUserSql;
    private String m_deleteUserSql;
    private JDBCUtil theJDBCUtil;
    private FileSystem fileSystem;

    public void removeUser(String userName) throws UsersRepositoryException {
        User user = this.getUserByName(userName);
        if (user == null) {
            throw new UsersRepositoryException("User " + userName + " does not exist");
        }
        this.doRemoveUser(user);
    }

    public User getUserByName(String name) throws UsersRepositoryException {
        return this.getUserByName(name, this.ignoreCase);
    }

    public boolean contains(String name) throws UsersRepositoryException {
        User user = this.getUserByName(name, this.ignoreCase);
        return user != null;
    }

    public boolean containsCaseInsensitive(String name) throws UsersRepositoryException {
        User user = this.getUserByName(name, true);
        return user != null;
    }

    public boolean test(String name, String password) throws UsersRepositoryException {
        User user = this.getUserByName(name, this.ignoreCase);
        if (user == null) {
            return false;
        }
        return user.verifyPassword(password);
    }

    public int countUsers() throws UsersRepositoryException {
        List<String> usernames = this.listUserNames();
        return usernames.size();
    }

    public Iterator<String> list() throws UsersRepositoryException {
        return this.listUserNames().iterator();
    }

    @Resource(name="datasource")
    public void setDatasource(DataSource m_datasource) {
        this.m_datasource = m_datasource;
    }

    @Resource(name="filesystem")
    public void setFileSystem(FileSystem system) {
        this.fileSystem = system;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() throws Exception {
        block13: {
            StringBuffer logBuffer = null;
            if (this.getLogger().isDebugEnabled()) {
                logBuffer = new StringBuffer(128).append(((Object)((Object)this)).getClass().getName()).append(".initialize()");
                this.getLogger().debug(logBuffer.toString());
            }
            this.theJDBCUtil = new JDBCUtil(){

                protected void delegatedLog(String logString) {
                    AbstractJdbcUsersRepository.this.getLogger().warn("AbstractJdbcUsersRepository: " + logString);
                }
            };
            Connection conn = this.openConnection();
            try {
                DatabaseMetaData dbMetaData = conn.getMetaData();
                InputStream sqlFile = null;
                try {
                    sqlFile = this.fileSystem.getResource(this.m_sqlFileName);
                }
                catch (Exception e) {
                    this.getLogger().error(e.getMessage(), (Throwable)e);
                    throw e;
                }
                if (this.getLogger().isDebugEnabled()) {
                    logBuffer = new StringBuffer(256).append("Reading SQL resources from: ").append(this.m_sqlFileName).append(", section ").append(((Object)((Object)this)).getClass().getName()).append(".");
                    this.getLogger().debug(logBuffer.toString());
                }
                SqlResources sqlStatements = new SqlResources();
                sqlStatements.init(sqlFile, ((Object)((Object)this)).getClass().getName(), conn, this.m_sqlParameters);
                this.m_getUsersSql = sqlStatements.getSqlString("select", true);
                this.m_userByNameCaseInsensitiveSql = sqlStatements.getSqlString("selectByLowercaseName");
                this.m_insertUserSql = sqlStatements.getSqlString("insert", true);
                this.m_updateUserSql = sqlStatements.getSqlString("update", true);
                this.m_deleteUserSql = sqlStatements.getSqlString("delete", true);
                String createUserTableSql = sqlStatements.getSqlString("createTable", true);
                String tableName = sqlStatements.getSqlString("tableName", true);
                if (!this.theJDBCUtil.tableExists(dbMetaData, tableName)) {
                    PreparedStatement createStatement = null;
                    try {
                        createStatement = conn.prepareStatement(createUserTableSql);
                        createStatement.execute();
                    }
                    finally {
                        this.theJDBCUtil.closeJDBCStatement((Statement)createStatement);
                    }
                    logBuffer = new StringBuffer(128).append(((Object)((Object)this)).getClass().getName()).append(": Created table '").append(tableName).append("'.");
                    this.getLogger().info(logBuffer.toString());
                    break block13;
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Using table: " + tableName);
                }
            }
            finally {
                this.theJDBCUtil.closeJDBCConnection(conn);
            }
        }
    }

    protected void doConfigure(HierarchicalConfiguration configuration) throws ConfigurationException {
        String destUrl;
        StringBuffer logBuffer = null;
        if (this.getLogger().isDebugEnabled()) {
            logBuffer = new StringBuffer(64).append(((Object)((Object)this)).getClass().getName()).append(".configure()");
            this.getLogger().debug(logBuffer.toString());
        }
        if ((destUrl = configuration.getString("[@destinationURL]", null)) == null) {
            throw new ConfigurationException("destinationURL attribute is missing from Configuration");
        }
        if (!destUrl.endsWith("/")) {
            destUrl = destUrl + "/";
        }
        ArrayList<String> urlParams = new ArrayList<String>();
        int start = 5;
        int end = destUrl.indexOf(47, start);
        while (end > -1) {
            urlParams.add(destUrl.substring(start, end));
            start = end + 1;
            end = destUrl.indexOf(47, start);
        }
        this.m_sqlParameters = new HashMap<String, String>();
        switch (urlParams.size()) {
            case 3: {
                this.m_sqlParameters.put("key", (String)urlParams.get(2));
            }
            case 2: {
                this.m_sqlParameters.put("table", (String)urlParams.get(1));
            }
            case 1: {
                this.m_datasourceName = (String)urlParams.get(0);
                break;
            }
            default: {
                throw new ConfigurationException("Malformed destinationURL - Must be of the format \"db://<data-source>[/<table>[/<key>]]\".");
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            logBuffer = new StringBuffer(128).append("Parsed URL: table = '").append(this.m_sqlParameters.get("table")).append("', key = '").append(this.m_sqlParameters.get("key")).append("'");
            this.getLogger().debug(logBuffer.toString());
        }
        this.m_sqlFileName = configuration.getString("sqlFile", null);
        Iterator paramIt = configuration.getKeys("sqlParameters");
        while (paramIt.hasNext()) {
            String rawName = (String)paramIt.next();
            String paramName = ((String)paramIt.next()).substring("sqlParameters.[@".length(), rawName.length() - 1);
            String paramValue = configuration.getString(rawName);
            this.m_sqlParameters.put(paramName, paramValue);
        }
    }

    protected List<String> listUserNames() throws UsersRepositoryException {
        Collection<User> users = this.getAllUsers();
        ArrayList<String> userNames = new ArrayList<String>(users.size());
        Iterator<User> it = users.iterator();
        while (it.hasNext()) {
            userNames.add(it.next().getUserName());
        }
        users.clear();
        return userNames;
    }

    protected Iterator<User> listAllUsers() throws UsersRepositoryException {
        return this.getAllUsers().iterator();
    }

    private Collection<User> getAllUsers() throws UsersRepositoryException {
        ArrayList<User> userList = new ArrayList<User>();
        Connection conn = null;
        PreparedStatement getUsersStatement = null;
        ResultSet rsUsers = null;
        try {
            conn = this.openConnection();
            getUsersStatement = conn.prepareStatement(this.m_getUsersSql);
            rsUsers = getUsersStatement.executeQuery();
            while (rsUsers.next()) {
                User user = this.readUserFromResultSet(rsUsers);
                userList.add(user);
            }
        }
        catch (SQLException sqlExc) {
            try {
                sqlExc.printStackTrace();
                throw new UsersRepositoryException("Error accessing database", (Throwable)sqlExc);
            }
            catch (Throwable throwable) {
                this.theJDBCUtil.closeJDBCResultSet(rsUsers);
                this.theJDBCUtil.closeJDBCStatement((Statement)getUsersStatement);
                this.theJDBCUtil.closeJDBCConnection(conn);
                throw throwable;
            }
        }
        this.theJDBCUtil.closeJDBCResultSet(rsUsers);
        this.theJDBCUtil.closeJDBCStatement((Statement)getUsersStatement);
        this.theJDBCUtil.closeJDBCConnection(conn);
        return userList;
    }

    protected void doAddUser(User user) throws UsersRepositoryException {
        Connection conn = null;
        PreparedStatement addUserStatement = null;
        try {
            conn = this.openConnection();
            addUserStatement = conn.prepareStatement(this.m_insertUserSql);
            this.setUserForInsertStatement(user, addUserStatement);
            addUserStatement.execute();
        }
        catch (SQLException sqlExc) {
            try {
                sqlExc.printStackTrace();
                throw new UsersRepositoryException("Error accessing database", (Throwable)sqlExc);
            }
            catch (Throwable throwable) {
                this.theJDBCUtil.closeJDBCStatement(addUserStatement);
                this.theJDBCUtil.closeJDBCConnection(conn);
                throw throwable;
            }
        }
        this.theJDBCUtil.closeJDBCStatement((Statement)addUserStatement);
        this.theJDBCUtil.closeJDBCConnection(conn);
    }

    protected void doRemoveUser(User user) throws UsersRepositoryException {
        String username = user.getUserName();
        Connection conn = null;
        PreparedStatement removeUserStatement = null;
        try {
            conn = this.openConnection();
            removeUserStatement = conn.prepareStatement(this.m_deleteUserSql);
            removeUserStatement.setString(1, username);
            removeUserStatement.execute();
        }
        catch (SQLException sqlExc) {
            try {
                sqlExc.printStackTrace();
                throw new UsersRepositoryException("Error accessing database", (Throwable)sqlExc);
            }
            catch (Throwable throwable) {
                this.theJDBCUtil.closeJDBCStatement(removeUserStatement);
                this.theJDBCUtil.closeJDBCConnection(conn);
                throw throwable;
            }
        }
        this.theJDBCUtil.closeJDBCStatement((Statement)removeUserStatement);
        this.theJDBCUtil.closeJDBCConnection(conn);
    }

    protected void doUpdateUser(User user) throws UsersRepositoryException {
        Connection conn = null;
        PreparedStatement updateUserStatement = null;
        try {
            conn = this.openConnection();
            updateUserStatement = conn.prepareStatement(this.m_updateUserSql);
            this.setUserForUpdateStatement(user, updateUserStatement);
            updateUserStatement.execute();
        }
        catch (SQLException sqlExc) {
            try {
                sqlExc.printStackTrace();
                throw new UsersRepositoryException("Error accessing database", (Throwable)sqlExc);
            }
            catch (Throwable throwable) {
                this.theJDBCUtil.closeJDBCStatement(updateUserStatement);
                this.theJDBCUtil.closeJDBCConnection(conn);
                throw throwable;
            }
        }
        this.theJDBCUtil.closeJDBCStatement((Statement)updateUserStatement);
        this.theJDBCUtil.closeJDBCConnection(conn);
    }

    protected User getUserByNameIterating(String name, boolean ignoreCase) throws UsersRepositoryException {
        Iterator<User> users = this.listAllUsers();
        while (users.hasNext()) {
            User user = users.next();
            String username = user.getUserName();
            if ((ignoreCase || !username.equals(name)) && (!ignoreCase || !username.equalsIgnoreCase(name))) continue;
            return user;
        }
        return null;
    }

    protected User getUserByName(String name, boolean ignoreCase) throws UsersRepositoryException {
        User user;
        if (this.m_userByNameCaseInsensitiveSql == null) {
            return this.getUserByNameIterating(name, ignoreCase);
        }
        Connection conn = null;
        PreparedStatement getUsersStatement = null;
        ResultSet rsUsers = null;
        try {
            conn = this.openConnection();
            String sql = this.m_userByNameCaseInsensitiveSql;
            getUsersStatement = conn.prepareStatement(sql);
            getUsersStatement.setString(1, name.toLowerCase(Locale.US));
            rsUsers = getUsersStatement.executeQuery();
            User user2 = null;
            while (rsUsers.next()) {
                User rowUser = this.readUserFromResultSet(rsUsers);
                String actualName = rowUser.getUserName();
                if (!ignoreCase && !actualName.equals(name)) continue;
                user2 = rowUser;
                break;
            }
            user = user2;
        }
        catch (SQLException sqlExc) {
            try {
                sqlExc.printStackTrace();
                throw new UsersRepositoryException("Error accessing database", (Throwable)sqlExc);
            }
            catch (Throwable throwable) {
                this.theJDBCUtil.closeJDBCResultSet(rsUsers);
                this.theJDBCUtil.closeJDBCStatement((Statement)getUsersStatement);
                this.theJDBCUtil.closeJDBCConnection(conn);
                throw throwable;
            }
        }
        this.theJDBCUtil.closeJDBCResultSet(rsUsers);
        this.theJDBCUtil.closeJDBCStatement((Statement)getUsersStatement);
        this.theJDBCUtil.closeJDBCConnection(conn);
        return user;
    }

    protected abstract User readUserFromResultSet(ResultSet var1) throws SQLException;

    protected abstract void setUserForInsertStatement(User var1, PreparedStatement var2) throws SQLException;

    protected abstract void setUserForUpdateStatement(User var1, PreparedStatement var2) throws SQLException;

    private Connection openConnection() throws SQLException {
        return this.m_datasource.getConnection();
    }
}

