/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.domainlist.lib;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.annotation.Resource;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.lifecycle.api.LogEnabled;
import org.slf4j.Logger;

public abstract class AbstractDomainList
implements DomainList,
LogEnabled,
Configurable {
    private DNSService dns;
    private boolean autoDetect = true;
    private boolean autoDetectIP = true;
    private Logger logger;
    private String defaultDomain;

    @Resource(name="dnsservice")
    public void setDNSService(DNSService dns) {
        this.dns = dns;
    }

    public void setLog(Logger logger) {
        this.logger = logger;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public void configure(HierarchicalConfiguration config) throws ConfigurationException {
        this.defaultDomain = config.getString("defaultDomain", "localhost");
        this.setAutoDetect(config.getBoolean("autodetect", true));
        this.setAutoDetectIP(config.getBoolean("autodetectIP", true));
    }

    public String getDefaultDomain() throws DomainListException {
        return this.defaultDomain;
    }

    public String[] getDomains() throws DomainListException {
        List<String> domains = this.getDomainListInternal();
        if (domains != null) {
            String hostName = null;
            try {
                hostName = this.getDNSServer().getHostName(this.getDNSServer().getLocalHost());
            }
            catch (UnknownHostException ue) {
                hostName = "localhost";
            }
            this.getLogger().info("Local host is: " + hostName);
            if (this.autoDetect && !hostName.equals("localhost")) {
                domains.add(hostName.toLowerCase(Locale.US));
            }
            if (this.autoDetectIP) {
                domains.addAll(AbstractDomainList.getDomainsIP(domains, this.dns, this.getLogger()));
            }
            if (this.getLogger().isInfoEnabled()) {
                Iterator<String> i = domains.iterator();
                while (i.hasNext()) {
                    this.getLogger().debug("Handling mail for: " + i.next());
                }
            }
            if (domains.isEmpty()) {
                return null;
            }
            return domains.toArray(new String[domains.size()]);
        }
        return null;
    }

    private static List<String> getDomainsIP(List<String> domains, DNSService dns, Logger log) {
        ArrayList<String> domainIP = new ArrayList<String>();
        if (domains.size() > 0) {
            for (int i = 0; i < domains.size(); ++i) {
                List<String> domList = AbstractDomainList.getDomainIP(domains.get(i).toString(), dns, log);
                for (int i2 = 0; i2 < domList.size(); ++i2) {
                    if (domainIP.contains(domList.get(i2))) continue;
                    domainIP.add(domList.get(i2));
                }
            }
        }
        return domainIP;
    }

    private static List<String> getDomainIP(String domain, DNSService dns, Logger log) {
        ArrayList<String> domainIP = new ArrayList<String>();
        try {
            InetAddress[] addrs = dns.getAllByName(domain);
            for (int j = 0; j < addrs.length; ++j) {
                String ip = addrs[j].getHostAddress();
                if (domainIP.contains(ip)) continue;
                domainIP.add(ip);
            }
        }
        catch (UnknownHostException e) {
            log.error("Cannot get IP address(es) for " + domain);
        }
        return domainIP;
    }

    public synchronized void setAutoDetect(boolean autoDetect) {
        this.getLogger().info("Set autodetect to: " + autoDetect);
        this.autoDetect = autoDetect;
    }

    public synchronized void setAutoDetectIP(boolean autoDetectIP) {
        this.getLogger().info("Set autodetectIP to: " + autoDetectIP);
        this.autoDetectIP = autoDetectIP;
    }

    protected DNSService getDNSServer() {
        return this.dns;
    }

    protected abstract List<String> getDomainListInternal() throws DomainListException;
}

