/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.lib;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import javax.mail.MessagingException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.lifecycle.api.LogEnabled;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.lib.Lock;
import org.apache.mailet.Mail;
import org.slf4j.Logger;

public abstract class AbstractMailRepository
implements MailRepository,
LogEnabled,
Configurable {
    protected static final boolean DEEP_DEBUG = false;
    private final Lock lock = new Lock();
    private Logger logger;

    public void setLog(Logger logger) {
        this.logger = logger;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public void configure(HierarchicalConfiguration configuration) throws ConfigurationException {
        this.doConfigure(configuration);
    }

    protected void doConfigure(HierarchicalConfiguration config) throws ConfigurationException {
    }

    public boolean unlock(String key) {
        return this.lock.unlock(key);
    }

    public boolean lock(String key) {
        return this.lock.lock(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(Mail mc) throws MessagingException {
        boolean wasLocked = true;
        String key = mc.getName();
        try {
            AbstractMailRepository abstractMailRepository = this;
            synchronized (abstractMailRepository) {
                wasLocked = this.lock.isLocked(key);
                if (!wasLocked) {
                    this.lock(key);
                }
            }
            this.internalStore(mc);
        }
        catch (MessagingException e) {
            this.getLogger().error("Exception caught while storing mail " + key, (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.getLogger().error("Exception caught while storing mail " + key, (Throwable)e);
            throw new MessagingException("Exception caught while storing mail " + key, e);
        }
        finally {
            if (!wasLocked) {
                this.unlock(key);
                AbstractMailRepository abstractMailRepository = this;
                synchronized (abstractMailRepository) {
                    this.notify();
                }
            }
        }
    }

    protected abstract void internalStore(Mail var1) throws MessagingException, IOException;

    public void remove(Mail mail) throws MessagingException {
        this.remove(mail.getName());
    }

    public void remove(Collection<Mail> mails) throws MessagingException {
        Iterator<Mail> delList = mails.iterator();
        while (delList.hasNext()) {
            this.remove(delList.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String key) throws MessagingException {
        if (this.lock(key)) {
            try {
                this.internalRemove(key);
            }
            finally {
                this.unlock(key);
            }
        } else {
            StringBuffer exceptionBuffer = new StringBuffer(64).append("Cannot lock ").append(key).append(" to remove it");
            throw new MessagingException(exceptionBuffer.toString());
        }
    }

    protected abstract void internalRemove(String var1) throws MessagingException;
}

