/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.repository.file;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.james.repository.api.StreamRepository;
import org.apache.james.repository.file.AbstractFileRepository;

public class FilePersistentStreamRepository
extends AbstractFileRepository
implements StreamRepository {
    @Override
    protected String getExtensionDecorator() {
        return ".FileStreamStore";
    }

    @Override
    public synchronized InputStream get(String key) {
        try {
            return this.getInputStream(key);
        }
        catch (IOException ioe) {
            String message = "Exception caught while retrieving a stream ";
            this.getLogger().warn("Exception caught while retrieving a stream ", (Throwable)ioe);
            throw new RuntimeException("Exception caught while retrieving a stream : " + ioe);
        }
    }

    @Override
    public synchronized OutputStream put(String key) {
        try {
            OutputStream outputStream = this.getOutputStream(key);
            return new BufferedOutputStream(outputStream);
        }
        catch (IOException ioe) {
            String message = "Exception caught while storing a stream ";
            this.getLogger().warn("Exception caught while storing a stream ", (Throwable)ioe);
            throw new RuntimeException("Exception caught while storing a stream : " + ioe);
        }
    }

    public long getSize(String key) {
        try {
            return this.getFile(key).length();
        }
        catch (IOException e) {
            return 0L;
        }
    }
}

