/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Resource;
import javax.mail.internet.ParseException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.lifecycle.api.LogEnabled;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.lib.RecipientRewriteTableUtil;
import org.apache.mailet.MailAddress;
import org.slf4j.Logger;

public abstract class AbstractRecipientRewriteTable
implements RecipientRewriteTable,
LogEnabled,
Configurable {
    private int mappingLimit = 10;
    private boolean recursive = true;
    private Logger logger;
    private DomainList domainList;

    @Resource(name="domainlist")
    public void setDomainList(DomainList domainList) {
        this.domainList = domainList;
    }

    public void configure(HierarchicalConfiguration config) throws ConfigurationException {
        this.setRecursiveMapping(config.getBoolean("recursiveMapping", true));
        try {
            this.setMappingLimit(config.getInt("mappingLimit", 10));
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException(e.getMessage());
        }
        this.doConfigure(config);
    }

    public void setLog(Logger logger) {
        this.logger = logger;
    }

    protected void doConfigure(HierarchicalConfiguration conf) throws ConfigurationException {
    }

    public void setRecursiveMapping(boolean recursive) {
        this.recursive = recursive;
    }

    public void setMappingLimit(int mappingLimit) throws IllegalArgumentException {
        if (mappingLimit < 1) {
            throw new IllegalArgumentException("The minimum mappingLimit is 1");
        }
        this.mappingLimit = mappingLimit;
    }

    public Collection<String> getMappings(String user, String domain) throws RecipientRewriteTable.ErrorMappingException, RecipientRewriteTableException {
        return this.getMappings(user, domain, this.mappingLimit);
    }

    public Collection<String> getMappings(String user, String domain, int mappingLimit) throws RecipientRewriteTable.ErrorMappingException, RecipientRewriteTableException {
        if (mappingLimit == 0) {
            throw new RecipientRewriteTable.ErrorMappingException("554 Too many mappings to process");
        }
        String targetString = this.mapAddress(user, domain);
        if (targetString != null) {
            ArrayList<String> mappings = new ArrayList<String>();
            if (targetString.startsWith("error:")) {
                throw new RecipientRewriteTable.ErrorMappingException(targetString.substring("error:".length()));
            }
            for (String target : RecipientRewriteTableUtil.mappingToCollection(targetString)) {
                if (target.startsWith("regex:")) {
                    try {
                        target = RecipientRewriteTableUtil.regexMap(new MailAddress(user, domain), target);
                    }
                    catch (PatternSyntaxException e) {
                        this.getLogger().error("Exception during regexMap processing: ", (Throwable)e);
                    }
                    catch (ParseException e) {
                        this.getLogger().error("Exception during regexMap processing: ", (Throwable)e);
                    }
                } else if (target.startsWith("domain:")) {
                    target = user + "@" + target.substring("domain:".length());
                }
                if (target == null) continue;
                StringBuffer buf = new StringBuffer().append("Valid virtual user mapping ").append(user).append("@").append(domain).append(" to ").append(target);
                this.getLogger().debug(buf.toString());
                if (this.recursive) {
                    String userName = null;
                    String domainName = null;
                    String[] args = target.split("@");
                    if (args != null && args.length > 1) {
                        userName = args[0];
                        domainName = args[1];
                    } else {
                        userName = target;
                        domainName = domain;
                    }
                    if (userName.equalsIgnoreCase(user) && domainName.equalsIgnoreCase(domain)) {
                        return null;
                    }
                    Collection<String> childMappings = this.getMappings(userName, domainName, mappingLimit - 1);
                    if (childMappings == null) {
                        mappings.add(target);
                        continue;
                    }
                    mappings.addAll(childMappings);
                    continue;
                }
                mappings.add(target);
            }
            return mappings;
        }
        return null;
    }

    public void addRegexMapping(String user, String domain, String regex) throws RecipientRewriteTableException {
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new RecipientRewriteTableException("Invalid regex: " + regex, (Throwable)e);
        }
        this.checkMapping(user, domain, regex);
        this.getLogger().info("Add regex mapping => " + regex + " for user: " + user + " domain: " + domain);
        this.addMappingInternal(user, domain, "regex:" + regex);
    }

    public void removeRegexMapping(String user, String domain, String regex) throws RecipientRewriteTableException {
        this.getLogger().info("Remove regex mapping => " + regex + " for user: " + user + " domain: " + domain);
        this.removeMappingInternal(user, domain, "regex:" + regex);
    }

    public void addAddressMapping(String user, String domain, String address) throws RecipientRewriteTableException {
        if (address.indexOf(64) < 0) {
            try {
                address = address + "@" + this.domainList.getDefaultDomain();
            }
            catch (DomainListException e) {
                throw new RecipientRewriteTableException("Unable to retrieve default domain", (Throwable)e);
            }
        }
        try {
            new MailAddress(address);
        }
        catch (ParseException e) {
            throw new RecipientRewriteTableException("Invalid emailAddress: " + address, (Throwable)e);
        }
        this.checkMapping(user, domain, address);
        this.getLogger().info("Add address mapping => " + address + " for user: " + user + " domain: " + domain);
        this.addMappingInternal(user, domain, address);
    }

    public void removeAddressMapping(String user, String domain, String address) throws RecipientRewriteTableException {
        if (address.indexOf(64) < 0) {
            try {
                address = address + "@" + this.domainList.getDefaultDomain();
            }
            catch (DomainListException e) {
                throw new RecipientRewriteTableException("Unable to retrieve default domain", (Throwable)e);
            }
        }
        this.getLogger().info("Remove address mapping => " + address + " for user: " + user + " domain: " + domain);
        this.removeMappingInternal(user, domain, address);
    }

    public void addErrorMapping(String user, String domain, String error) throws RecipientRewriteTableException {
        this.checkMapping(user, domain, error);
        this.getLogger().info("Add error mapping => " + error + " for user: " + user + " domain: " + domain);
        this.addMappingInternal(user, domain, "error:" + error);
    }

    public void removeErrorMapping(String user, String domain, String error) throws RecipientRewriteTableException {
        this.getLogger().info("Remove error mapping => " + error + " for user: " + user + " domain: " + domain);
        this.removeMappingInternal(user, domain, "error:" + error);
    }

    public void addMapping(String user, String domain, String mapping) throws RecipientRewriteTableException {
        String map = mapping.toLowerCase();
        if (map.startsWith("error:")) {
            this.addErrorMapping(user, domain, map.substring("error:".length()));
        } else if (map.startsWith("regex:")) {
            this.addRegexMapping(user, domain, map.substring("regex:".length()));
        } else if (map.startsWith("domain:")) {
            if (user != null) {
                throw new RecipientRewriteTableException("User must be null for aliasDomain mappings");
            }
            this.addAliasDomainMapping(domain, map.substring("domain:".length()));
        } else {
            this.addAddressMapping(user, domain, map);
        }
    }

    public void removeMapping(String user, String domain, String mapping) throws RecipientRewriteTableException {
        String map = mapping.toLowerCase();
        if (map.startsWith("error:")) {
            this.removeErrorMapping(user, domain, map.substring("error:".length()));
        } else if (map.startsWith("regex:")) {
            this.removeRegexMapping(user, domain, map.substring("regex:".length()));
        } else if (map.startsWith("domain:")) {
            if (user != null) {
                throw new RecipientRewriteTableException("User must be null for aliasDomain mappings");
            }
            this.removeAliasDomainMapping(domain, map.substring("domain:".length()));
        } else {
            this.removeAddressMapping(user, domain, map);
        }
    }

    public Map<String, Collection<String>> getAllMappings() throws RecipientRewriteTableException {
        int count = 0;
        Map<String, Collection<String>> mappings = this.getAllMappingsInternal();
        if (mappings != null) {
            count = mappings.size();
        }
        this.getLogger().debug("Retrieve all mappings. Mapping count: " + count);
        return mappings;
    }

    public Collection<String> getUserDomainMappings(String user, String domain) throws RecipientRewriteTableException {
        return this.getUserDomainMappingsInternal(user, domain);
    }

    public void addAliasDomainMapping(String aliasDomain, String realDomain) throws RecipientRewriteTableException {
        this.getLogger().info("Add domain mapping: " + aliasDomain + " => " + realDomain);
        this.addMappingInternal(null, aliasDomain, "domain:" + realDomain);
    }

    public void removeAliasDomainMapping(String aliasDomain, String realDomain) throws RecipientRewriteTableException {
        this.getLogger().info("Remove domain mapping: " + aliasDomain + " => " + realDomain);
        this.removeMappingInternal(null, aliasDomain, "domain:" + realDomain);
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected abstract void addMappingInternal(String var1, String var2, String var3) throws RecipientRewriteTableException;

    protected abstract void removeMappingInternal(String var1, String var2, String var3) throws RecipientRewriteTableException;

    protected abstract Collection<String> getUserDomainMappingsInternal(String var1, String var2) throws RecipientRewriteTableException;

    protected abstract Map<String, Collection<String>> getAllMappingsInternal() throws RecipientRewriteTableException;

    protected abstract String mapAddressInternal(String var1, String var2) throws RecipientRewriteTableException;

    private String mapAddress(String user, String domain) throws RecipientRewriteTableException {
        String mappings = this.mapAddressInternal(user, domain);
        if (mappings != null && mappings.indexOf("domain:") > -1) {
            ArrayList<String> mapCol = RecipientRewriteTableUtil.mappingToCollection(mappings);
            Iterator mapIt = mapCol.iterator();
            ArrayList<String> col = new ArrayList<String>(mapCol.size());
            while (mapIt.hasNext()) {
                int i = 0;
                String mapping = ((String)mapIt.next()).toString();
                if (mapping.startsWith("domain:")) {
                    col.add(i, mapping);
                    ++i;
                    continue;
                }
                col.add(mapping);
            }
            return RecipientRewriteTableUtil.CollectionToMapping(col);
        }
        return mappings;
    }

    private void checkMapping(String user, String domain, String mapping) throws RecipientRewriteTableException {
        Collection<String> mappings = this.getUserDomainMappings(user, domain);
        if (mappings != null && mappings.contains(mapping)) {
            throw new RecipientRewriteTableException("Mapping " + mapping + " for user " + user + " domain " + domain + " already exist!");
        }
    }
}

