/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.lib;

import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.api.RecipientRewriteTableManagementMBean;

public class RecipientRewriteTableManagement
extends StandardMBean
implements RecipientRewriteTableManagementMBean {
    private RecipientRewriteTable vut;

    protected RecipientRewriteTableManagement() throws NotCompliantMBeanException {
        super(RecipientRewriteTableManagementMBean.class);
    }

    @Resource(name="recipientrewritetable")
    public void setManageableRecipientRewriteTable(RecipientRewriteTable vut) {
        this.vut = vut;
    }

    public void addRegexMapping(String user, String domain, String regex) throws Exception {
        try {
            this.vut.addRegexMapping(user, domain, regex);
        }
        catch (RecipientRewriteTableException e) {
            throw new Exception(e.getMessage());
        }
    }

    public void removeRegexMapping(String user, String domain, String regex) throws Exception {
        try {
            this.vut.removeRegexMapping(user, domain, regex);
        }
        catch (RecipientRewriteTableException e) {
            throw new Exception(e.getMessage());
        }
    }

    public void addAddressMapping(String user, String domain, String address) throws Exception {
        try {
            this.vut.addAddressMapping(user, domain, address);
        }
        catch (RecipientRewriteTableException e) {
            throw new Exception(e.getMessage());
        }
    }

    public void removeAddressMapping(String user, String domain, String address) throws Exception {
        try {
            this.vut.removeAddressMapping(user, domain, address);
        }
        catch (RecipientRewriteTableException e) {
            throw new Exception(e.getMessage());
        }
    }

    public void addErrorMapping(String user, String domain, String error) throws Exception {
        try {
            this.vut.addErrorMapping(user, domain, error);
        }
        catch (RecipientRewriteTableException e) {
            throw new Exception(e.getMessage());
        }
    }

    public void removeErrorMapping(String user, String domain, String error) throws Exception {
        try {
            this.vut.removeErrorMapping(user, domain, error);
        }
        catch (RecipientRewriteTableException e) {
            throw new Exception(e.getMessage());
        }
    }

    public void addDomainMapping(String domain, String targetDomain) throws Exception {
        try {
            this.vut.addAliasDomainMapping(domain, targetDomain);
        }
        catch (RecipientRewriteTableException e) {
            throw new Exception(e.getMessage());
        }
    }

    public void removeDomainMapping(String domain, String targetDomain) throws Exception {
        try {
            this.vut.removeAliasDomainMapping(domain, targetDomain);
        }
        catch (RecipientRewriteTableException e) {
            throw new Exception(e.getMessage());
        }
    }

    public Collection<String> getUserDomainMappings(String user, String domain) throws Exception {
        try {
            return this.vut.getUserDomainMappings(user, domain);
        }
        catch (RecipientRewriteTableException e) {
            throw new Exception(e.getMessage());
        }
    }

    public void addMapping(String user, String domain, String mapping) throws Exception {
        try {
            this.vut.addMapping(user, domain, mapping);
        }
        catch (RecipientRewriteTableException e) {
            throw new Exception(e.getMessage());
        }
    }

    public void removeMapping(String user, String domain, String mapping) throws Exception {
        try {
            this.vut.removeMapping(user, domain, mapping);
        }
        catch (RecipientRewriteTableException e) {
            throw new Exception(e.getMessage());
        }
    }

    public Map<String, Collection<String>> getAllMappings() throws Exception {
        try {
            return this.vut.getAllMappings();
        }
        catch (RecipientRewriteTableException e) {
            throw new Exception(e.getMessage());
        }
    }
}

