/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.mailet.MailAddress;

public class RecipientRewriteTableUtil {
    public static String QUERY = "select RecipientRewriteTable.target_address from RecipientRewriteTable, RecipientRewriteTable as VUTDomains where (RecipientRewriteTable.user like ? or RecipientRewriteTable.user like '\\%') and (RecipientRewriteTable.domain like ? or (RecipientRewriteTable.domain like '%*%' and VUTDomains.domain like ?)) order by concat(RecipientRewriteTable.user,'@',RecipientRewriteTable.domain) desc limit 1";

    private RecipientRewriteTableUtil() {
    }

    public static String regexMap(MailAddress address, String targetString) {
        String result = null;
        int identifierLength = "regex:".length();
        int msgPos = targetString.indexOf(58, identifierLength + 1);
        if (msgPos < identifierLength + 1) {
            throw new PatternSyntaxException("Regex should be formatted as regex:<regular-expression>:<parameterized-string>", targetString, 0);
        }
        Pattern pattern = Pattern.compile(targetString.substring(identifierLength, msgPos));
        Matcher match = pattern.matcher(address.toString());
        if (match.matches()) {
            HashMap<String, String> parameters = new HashMap<String, String>(match.groupCount());
            for (int i = 1; i < match.groupCount(); ++i) {
                parameters.put(Integer.toString(i), match.group(i));
            }
            result = RecipientRewriteTableUtil.replaceParameters(targetString.substring(msgPos + 1), parameters);
        }
        return result;
    }

    public static String replaceParameters(String str, Map<String, String> parameters) {
        if (str != null && parameters != null) {
            StringBuffer replaceBuffer = new StringBuffer(64);
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                replaceBuffer.setLength(0);
                replaceBuffer.append("${").append(entry.getKey()).append("}");
                str = RecipientRewriteTableUtil.substituteSubString(str, replaceBuffer.toString(), entry.getValue());
            }
        }
        return str;
    }

    private static String substituteSubString(String input, String find, String replace) {
        int find_length = find.length();
        int replace_length = replace.length();
        StringBuffer output = new StringBuffer(input);
        int index = input.indexOf(find);
        int outputOffset = 0;
        while (index > -1) {
            output.replace(index + outputOffset, index + outputOffset + find_length, replace);
            outputOffset += replace_length - find_length;
            index = input.indexOf(find, index + find_length);
        }
        String result = output.toString();
        return result;
    }

    public static String getTargetString(String user, String domain, Map<String, String> mappings) {
        StringBuffer buf = new StringBuffer().append(user).append("@").append(domain);
        String target = mappings.get(buf.toString());
        if (target != null) {
            return target;
        }
        buf = new StringBuffer().append(user).append("@*");
        target = mappings.get(buf.toString());
        if (target != null) {
            return target;
        }
        buf = new StringBuffer().append("*@").append(domain);
        target = mappings.get(buf.toString());
        if (target != null) {
            return target;
        }
        return null;
    }

    public static String getSeparator(String targetString) {
        return targetString.indexOf(44) > -1 ? "," : (targetString.indexOf(59) > -1 ? ";" : (targetString.indexOf("error:") > -1 || targetString.indexOf("regex:") > -1 || targetString.indexOf("domain:") > -1 ? "" : ":"));
    }

    public static Map<String, String> getXMLMappings(String mapping) {
        HashMap<String, String> mappings = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(mapping, ",");
        while (tokenizer.hasMoreTokens()) {
            String mappingItem = tokenizer.nextToken();
            int index = mappingItem.indexOf(61);
            String virtual = mappingItem.substring(0, index).trim().toLowerCase();
            String real = mappingItem.substring(index + 1).trim().toLowerCase();
            mappings.put(virtual, real);
        }
        return mappings;
    }

    public static Collection<String> getMappings(String rawMapping) {
        return RecipientRewriteTableUtil.mappingToCollection(rawMapping);
    }

    public static ArrayList<String> mappingToCollection(String rawMapping) {
        ArrayList<String> map = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(rawMapping, RecipientRewriteTableUtil.getSeparator(rawMapping));
        while (tokenizer.hasMoreTokens()) {
            String raw = tokenizer.nextToken().trim();
            map.add(raw);
        }
        return map;
    }

    public static String CollectionToMapping(Collection<String> map) {
        StringBuffer mapping = new StringBuffer();
        Iterator<String> mappings = map.iterator();
        while (mappings.hasNext()) {
            mapping.append(mappings.next());
            if (!mappings.hasNext()) continue;
            mapping.append(";");
        }
        return mapping.toString();
    }
}

