/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.lib;

import javax.annotation.Resource;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.lifecycle.api.LogEnabled;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.slf4j.Logger;

public abstract class AbstractUsersRepository
implements UsersRepository,
LogEnabled,
Configurable {
    private DomainList domainList;
    private boolean virtualHosting;
    private Logger logger;

    protected Logger getLogger() {
        return this.logger;
    }

    public void setLog(Logger logger) {
        this.logger = logger;
    }

    public void configure(HierarchicalConfiguration configuration) throws ConfigurationException {
        this.virtualHosting = configuration.getBoolean("enableVirtualHosting", false);
        this.doConfigure(configuration);
    }

    protected void doConfigure(HierarchicalConfiguration config) throws ConfigurationException {
    }

    public void setEnableVirtualHosting(boolean virtualHosting) {
        this.virtualHosting = virtualHosting;
    }

    @Resource(name="domainlist")
    public void setDomainList(DomainList domainList) {
        this.domainList = domainList;
    }

    protected void isValidUsername(String username) throws UsersRepositoryException {
        int i = username.indexOf("@");
        if (this.supportVirtualHosting()) {
            if (i == -1) {
                throw new UsersRepositoryException("Given Username needs to contain a @domainpart");
            }
            String domain = username.substring(i + 1);
            try {
                if (!this.domainList.containsDomain(domain)) {
                    throw new UsersRepositoryException("Domain does not exist in DomainList");
                }
                return;
            }
            catch (DomainListException e) {
                throw new UsersRepositoryException("Unable to query DomainList", (Throwable)e);
            }
        }
        if (i != -1) {
            throw new UsersRepositoryException("Given Username contains a @domainpart but virtualhosting support is disabled");
        }
    }

    public void addUser(String username, String password) throws UsersRepositoryException {
        if (this.contains(username)) {
            throw new UsersRepositoryException("User with username " + username + " already exist!");
        }
        this.isValidUsername(username);
        this.doAddUser(username, password);
    }

    public boolean supportVirtualHosting() throws UsersRepositoryException {
        return this.virtualHosting;
    }

    protected abstract void doAddUser(String var1, String var2) throws UsersRepositoryException;
}

