/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.lib;

import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Resource;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.api.UsersRepositoryManagementMBean;
import org.apache.james.user.api.model.JamesUser;
import org.apache.james.user.api.model.User;

public class UsersRepositoryManagement
extends StandardMBean
implements UsersRepositoryManagementMBean {
    private UsersRepository localUsers;

    @Resource(name="usersrepository")
    public void setUsersRepository(UsersRepository localUsers) {
        this.localUsers = localUsers;
    }

    public UsersRepositoryManagement() throws NotCompliantMBeanException {
        super(UsersRepositoryManagementMBean.class);
    }

    private JamesUser getJamesUser(String userName) throws UsersRepositoryException {
        User baseuser = this.localUsers.getUserByName(userName);
        if (baseuser == null) {
            throw new IllegalArgumentException("user not found: " + userName);
        }
        if (!(baseuser instanceof JamesUser)) {
            throw new IllegalArgumentException("user is not of type JamesUser: " + userName);
        }
        return (JamesUser)baseuser;
    }

    public void addUser(String userName, String password) throws Exception {
        try {
            this.localUsers.addUser(userName, password);
        }
        catch (UsersRepositoryException e) {
            throw new Exception(e.getMessage());
        }
    }

    public void deleteUser(String userName) throws Exception {
        try {
            this.localUsers.removeUser(userName);
        }
        catch (UsersRepositoryException e) {
            throw new Exception(e.getMessage());
        }
    }

    public boolean verifyExists(String userName) throws Exception {
        try {
            return this.localUsers.contains(userName);
        }
        catch (UsersRepositoryException e) {
            throw new Exception(e.getMessage());
        }
    }

    public long countUsers() throws Exception {
        try {
            return this.localUsers.countUsers();
        }
        catch (UsersRepositoryException e) {
            throw new Exception(e.getMessage());
        }
    }

    public String[] listAllUsers() throws Exception {
        ArrayList userNames = new ArrayList();
        try {
            Iterator it = this.localUsers.list();
            while (it.hasNext()) {
                userNames.add(it.next());
            }
        }
        catch (UsersRepositoryException e) {
            throw new Exception(e.getMessage());
        }
        return userNames.toArray(new String[0]);
    }

    public void setPassword(String userName, String password) throws Exception {
        try {
            User user = this.localUsers.getUserByName(userName);
            if (user == null) {
                throw new UsersRepositoryException("user not found: " + userName);
            }
            if (!user.setPassword(password)) {
                throw new UsersRepositoryException("Unable to update password for user " + user);
            }
            this.localUsers.updateUser(user);
        }
        catch (UsersRepositoryException e) {
            throw new Exception(e.getMessage());
        }
    }

    public void unsetAlias(String userName) throws Exception {
        try {
            JamesUser user = this.getJamesUser(userName);
            if (!user.getAliasing()) {
                throw new UsersRepositoryException("User " + user + " is no alias");
            }
            user.setAliasing(false);
            this.localUsers.updateUser((User)user);
        }
        catch (UsersRepositoryException e) {
            throw new Exception(e.getMessage());
        }
    }

    public String getAlias(String userName) throws Exception {
        try {
            JamesUser user = this.getJamesUser(userName);
            if (!user.getAliasing()) {
                return null;
            }
            return user.getAlias();
        }
        catch (UsersRepositoryException e) {
            throw new Exception(e.getMessage());
        }
    }

    public void unsetForwardAddress(String userName) throws Exception {
        try {
            JamesUser user = this.getJamesUser(userName);
            if (!user.getForwarding()) {
                throw new UsersRepositoryException("User " + user + " is no forward");
            }
            user.setForwarding(false);
            this.localUsers.updateUser((User)user);
        }
        catch (UsersRepositoryException e) {
            throw new Exception(e.getMessage());
        }
    }

    public String getForwardAddress(String userName) throws Exception {
        try {
            JamesUser user = this.getJamesUser(userName);
            if (!user.getForwarding()) {
                return null;
            }
            return user.getForwardingDestination().toString();
        }
        catch (UsersRepositoryException e) {
            throw new Exception(e.getMessage());
        }
    }

    public boolean getVirtualHostingEnabled() throws Exception {
        try {
            return this.localUsers.supportVirtualHosting();
        }
        catch (UsersRepositoryException e) {
            throw new Exception(e.getMessage());
        }
    }
}

