/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.lmtpserver;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.MailImpl;
import org.apache.james.core.MimeMessageCopyOnWriteProxy;
import org.apache.james.core.MimeMessageInputStream;
import org.apache.james.core.MimeMessageInputStreamSource;
import org.apache.james.core.MimeMessageSource;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPath;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.protocols.api.LineHandler;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.DataLineFilter;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;

public class DataLineLMTPMessageHookHandler
implements DataLineFilter {
    private UsersRepository users;
    private MailboxManager mailboxManager;

    @Resource(name="usersrepository")
    public final void setUsersRepository(UsersRepository users) {
        this.users = users;
    }

    @Resource(name="mailboxmanager")
    public final void setMailboxManager(MailboxManager mailboxManager) {
        this.mailboxManager = mailboxManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLine(SMTPSession session, byte[] line, LineHandler<SMTPSession> next) {
        MimeMessageInputStreamSource mmiss = (MimeMessageInputStreamSource)session.getState().get("org.apache.james.core.DataCmdHandler.DATA_MIMEMESSAGE_STREAMSOURCE");
        try {
            OutputStream out;
            block8: {
                block9: {
                    out = mmiss.getWritableOutputStream();
                    if (line.length != 3 || line[0] != 46) break block9;
                    out.flush();
                    out.close();
                    List recipientCollection = (List)session.getState().get("RCPT_LIST");
                    MailImpl mail = new MailImpl(MailImpl.getId(), (MailAddress)session.getState().get("SENDER_ADDRESS"), (Collection)recipientCollection);
                    session.getState().put("MAIL", mail);
                    MimeMessageCopyOnWriteProxy mimeMessageCopyOnWriteProxy = null;
                    try {
                        mimeMessageCopyOnWriteProxy = new MimeMessageCopyOnWriteProxy((MimeMessageSource)mmiss);
                        mail.setMessage((MimeMessage)mimeMessageCopyOnWriteProxy);
                        this.deliverMail(session, (Mail)mail);
                        session.popLineHandler();
                        session.resetState();
                    }
                    catch (MessagingException e) {
                        try {
                            session.getLogger().info("Unexpected error handling DATA stream", (Throwable)e);
                            session.writeResponse((Response)new SMTPResponse("451", (CharSequence)"Unexpected error handling DATA stream."));
                        }
                        catch (Throwable throwable) {
                            LifecycleUtil.dispose(mimeMessageCopyOnWriteProxy);
                            LifecycleUtil.dispose((Object)mmiss);
                            LifecycleUtil.dispose((Object)mail);
                            throw throwable;
                        }
                        LifecycleUtil.dispose((Object)mimeMessageCopyOnWriteProxy);
                        LifecycleUtil.dispose((Object)mmiss);
                        LifecycleUtil.dispose((Object)mail);
                        break block8;
                    }
                    LifecycleUtil.dispose((Object)mimeMessageCopyOnWriteProxy);
                    LifecycleUtil.dispose((Object)mmiss);
                    LifecycleUtil.dispose((Object)mail);
                    break block8;
                }
                if (line[0] == 46 && line[1] == 46) {
                    out.write(line, 1, line.length - 1);
                } else {
                    out.write(line);
                }
            }
            out.flush();
        }
        catch (IOException e) {
            LifecycleUtil.dispose((Object)mmiss);
            SMTPResponse response = new SMTPResponse("451", (CharSequence)(DSNStatus.getStatus((int)4, (String)"0.0") + " Error processing message: " + e.getMessage()));
            session.getLogger().error("Unknown error occurred while processing DATA.", (Throwable)e);
            session.writeResponse((Response)response);
            return;
        }
    }

    protected void deliverMail(SMTPSession session, Mail mail) {
        for (MailAddress recipient : mail.getRecipients()) {
            SMTPResponse response = null;
            try {
                String username = this.users.supportVirtualHosting() ? recipient.toString() : recipient.getLocalPart();
                MailboxSession mailboxSession = this.mailboxManager.createSystemSession(username, session.getLogger());
                MailboxPath inbox = MailboxPath.inbox((MailboxSession)mailboxSession);
                this.mailboxManager.startProcessingRequest(mailboxSession);
                if (!this.mailboxManager.mailboxExists(inbox, mailboxSession)) {
                    this.mailboxManager.createMailbox(inbox, mailboxSession);
                }
                this.mailboxManager.getMailbox(MailboxPath.inbox((MailboxSession)mailboxSession), mailboxSession).appendMessage((InputStream)new MimeMessageInputStream(mail.getMessage()), new Date(), mailboxSession, true, null);
                this.mailboxManager.endProcessingRequest(mailboxSession);
                response = new SMTPResponse("250", (CharSequence)(DSNStatus.getStatus((int)2, (String)"6.0") + " Message received"));
            }
            catch (MessagingException e) {
                session.getLogger().info("Unexpected error handling DATA stream", (Throwable)e);
                response = new SMTPResponse("451", (CharSequence)(DSNStatus.getStatus((int)4, (String)"0.0") + " Temporary error deliver message to " + recipient));
            }
            catch (MailboxException e) {
                session.getLogger().info("Unexpected error handling DATA stream", (Throwable)e);
                response = new SMTPResponse("451", (CharSequence)(DSNStatus.getStatus((int)4, (String)"0.0") + " Temporary error deliver message to " + recipient));
            }
            catch (UsersRepositoryException e) {
                session.getLogger().info("Unexpected error handling DATA stream", (Throwable)e);
                response = new SMTPResponse("451", (CharSequence)(DSNStatus.getStatus((int)4, (String)"0.0") + " Temporary error deliver message to " + recipient));
            }
            session.writeResponse((Response)response);
        }
    }
}

