/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.lmtpserver.netty;

import javax.net.ssl.SSLContext;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.lmtpserver.CoreCmdHandlerLoader;
import org.apache.james.lmtpserver.jmx.JMXHandlersLoader;
import org.apache.james.lmtpserver.netty.LMTPServerMBean;
import org.apache.james.protocols.api.HandlersPackage;
import org.apache.james.protocols.lib.netty.AbstractProtocolAsyncServer;
import org.apache.james.protocols.smtp.SMTPConfiguration;
import org.apache.james.smtpserver.netty.SMTPChannelUpstreamHandler;
import org.apache.james.smtpserver.netty.SMTPResponseEncoder;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;

public class LMTPServer
extends AbstractProtocolAsyncServer
implements LMTPServerMBean {
    private long maxMessageSize = 0L;
    private LMTPConfiguration lmtpConfig = new LMTPConfiguration();
    private String lmtpGreeting;

    public int getDefaultPort() {
        return 24;
    }

    public String getServiceType() {
        return "LMTP Service";
    }

    public void doConfigure(HierarchicalConfiguration configuration) throws ConfigurationException {
        super.doConfigure(configuration);
        if (this.isEnabled()) {
            this.maxMessageSize = configuration.getLong("maxmessagesize", this.maxMessageSize) * 1024L;
            if (this.maxMessageSize > 0L) {
                this.getLogger().info("The maximum allowed message size is " + this.maxMessageSize + " bytes.");
            } else {
                this.getLogger().info("No maximum message size is enforced for this server.");
            }
            this.lmtpGreeting = configuration.getString("lmtpGreeting", null);
        }
    }

    @Override
    public long getMaximalMessageSize() {
        return this.lmtpConfig.getMaxMessageSize();
    }

    protected String getDefaultJMXName() {
        return "lmtpserver";
    }

    @Override
    public void setMaximalMessageSize(long maxSize) {
        this.maxMessageSize = maxSize;
    }

    @Override
    public String getHeloName() {
        return this.lmtpConfig.getHelloName();
    }

    protected ChannelUpstreamHandler createCoreHandler() {
        return new SMTPChannelUpstreamHandler(this.getProtocolHandlerChain(), (SMTPConfiguration)this.lmtpConfig, this.getLogger());
    }

    protected OneToOneEncoder createEncoder() {
        return new SMTPResponseEncoder();
    }

    protected SSLContext getSSLContext() {
        return null;
    }

    protected boolean isSSLSocket() {
        return false;
    }

    protected Class<? extends HandlersPackage> getCoreHandlersPackage() {
        return CoreCmdHandlerLoader.class;
    }

    protected Class<? extends HandlersPackage> getJMXHandlersPackage() {
        return JMXHandlersLoader.class;
    }

    public class LMTPConfiguration
    implements SMTPConfiguration {
        public String getHelloName() {
            return LMTPServer.this.getHelloName();
        }

        public int getResetLength() {
            return -1;
        }

        public long getMaxMessageSize() {
            return LMTPServer.this.maxMessageSize;
        }

        public boolean isRelayingAllowed(String remoteIP) {
            return false;
        }

        public boolean useHeloEhloEnforcement() {
            return false;
        }

        public String getSMTPGreeting() {
            return LMTPServer.this.lmtpGreeting;
        }

        public boolean useAddressBracketsEnforcement() {
            return true;
        }

        public boolean isAuthRequired(String remoteIP) {
            return true;
        }

        public boolean isStartTLSSupported() {
            return false;
        }
    }
}

