/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.jcr.model;

import org.apache.jackrabbit.util.Text;
import org.apache.james.user.api.model.User;

public class JCRUser
implements User {
    public static final String SALT = "JCRUsersRepository";
    private final String userName;
    private String hashedSaltedPassword;

    public static String hashPassword(String username, String password) {
        String hashedSaltedPassword = Text.md5((String)(Text.md5((String)(username + password)) + SALT));
        return hashedSaltedPassword;
    }

    public JCRUser(String userName, String hashedSaltedPassword) {
        this.userName = userName;
        this.hashedSaltedPassword = hashedSaltedPassword;
    }

    public String getUserName() {
        return this.userName;
    }

    public final String getHashedSaltedPassword() {
        return this.hashedSaltedPassword;
    }

    public boolean setPassword(String newPass) {
        boolean result;
        if (newPass == null) {
            result = false;
        } else {
            this.hashedSaltedPassword = JCRUser.hashPassword(this.userName, newPass);
            result = true;
        }
        return result;
    }

    public boolean verifyPassword(String pass) {
        boolean result = pass == null ? false : this.hashedSaltedPassword.equals(JCRUser.hashPassword(this.userName, pass));
        return result;
    }
}

