/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.impl;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.ServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAsyncServer {
    public static final int DEFAULT_IO_WORKER_COUNT = Runtime.getRuntime().availableProcessors() * 2;
    private int backlog = 250;
    private int timeout = 120;
    private ServerBootstrap bootstrap;
    private boolean started;
    private ChannelGroup channels = new DefaultChannelGroup();
    private int ioWorker = DEFAULT_IO_WORKER_COUNT;
    private List<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();

    public synchronized void setListenAddresses(List<InetSocketAddress> addresses) {
        this.addresses = Collections.unmodifiableList(addresses);
    }

    public synchronized void setIoWorkerCount(int ioWorker) {
        if (this.started) {
            throw new IllegalStateException("Can only be set when the server is not running");
        }
        this.ioWorker = ioWorker;
    }

    public synchronized int getIoWorkerCount() {
        return this.ioWorker;
    }

    public synchronized void bind() throws Exception {
        if (this.started) {
            throw new IllegalStateException("Server running already");
        }
        if (this.addresses.isEmpty()) {
            throw new RuntimeException("Please specify at least on socketaddress to which the server should get bound!");
        }
        this.bootstrap = new ServerBootstrap((ChannelFactory)this.createSocketChannelFactory());
        ChannelPipelineFactory factory = this.createPipelineFactory(this.channels);
        this.bootstrap.setPipelineFactory(factory);
        this.configureBootstrap(this.bootstrap);
        for (int i = 0; i < this.addresses.size(); ++i) {
            this.channels.add((Object)this.bootstrap.bind((SocketAddress)this.addresses.get(i)));
        }
        this.started = true;
    }

    protected void configureBootstrap(ServerBootstrap bootstrap) {
        bootstrap.setOption("backlog", (Object)this.backlog);
        bootstrap.setOption("reuseAddress", (Object)true);
        bootstrap.setOption("child.tcpNoDelay", (Object)true);
    }

    protected ServerSocketChannelFactory createSocketChannelFactory() {
        return new NioServerSocketChannelFactory(this.createBossExecutor(), this.createWorkerExecutor(), this.ioWorker);
    }

    public synchronized void unbind() {
        if (!this.started) {
            return;
        }
        this.channels.close().awaitUninterruptibly();
        this.bootstrap.releaseExternalResources();
        this.started = false;
    }

    public synchronized List<InetSocketAddress> getListenAddresses() {
        return this.addresses;
    }

    protected abstract ChannelPipelineFactory createPipelineFactory(ChannelGroup var1);

    public synchronized void setTimeout(int timeout) {
        if (this.started) {
            throw new IllegalStateException("Can only be set when the server is not running");
        }
        this.timeout = timeout;
    }

    public synchronized void setBacklog(int backlog) {
        if (this.started) {
            throw new IllegalStateException("Can only be set when the server is not running");
        }
        this.backlog = backlog;
    }

    public synchronized int getBacklog() {
        return this.backlog;
    }

    public synchronized int getTimeout() {
        return this.timeout;
    }

    protected Executor createBossExecutor() {
        return Executors.newCachedThreadPool();
    }

    protected Executor createWorkerExecutor() {
        return Executors.newCachedThreadPool();
    }

    public synchronized boolean isBound() {
        return this.started;
    }
}

