/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.impl;

import org.apache.james.protocols.impl.ChannelGroupHandler;
import org.apache.james.protocols.impl.TimeoutHandler;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.handler.codec.frame.DelimiterBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.Delimiters;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;
import org.jboss.netty.handler.connection.ConnectionLimitUpstreamHandler;
import org.jboss.netty.handler.connection.ConnectionPerIpLimitUpstreamHandler;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;

public abstract class AbstractChannelPipelineFactory
implements ChannelPipelineFactory {
    public static final int MAX_LINE_LENGTH = 8192;
    private final ConnectionLimitUpstreamHandler connectionLimitHandler;
    private final ConnectionPerIpLimitUpstreamHandler connectionPerIpLimitHandler;
    private final HashedWheelTimer timer = new HashedWheelTimer();
    private ChannelGroupHandler groupHandler;
    private int timeout;

    public AbstractChannelPipelineFactory(int timeout, int maxConnections, int maxConnectsPerIp, ChannelGroup channels) {
        this.connectionLimitHandler = new ConnectionLimitUpstreamHandler(maxConnections);
        this.connectionPerIpLimitHandler = new ConnectionPerIpLimitUpstreamHandler(maxConnectsPerIp);
        this.groupHandler = new ChannelGroupHandler(channels);
        this.timeout = timeout;
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("groupHandler", (ChannelHandler)this.groupHandler);
        pipeline.addLast("connectionLimit", (ChannelHandler)this.connectionLimitHandler);
        pipeline.addLast("connectionPerIpLimit", (ChannelHandler)this.connectionPerIpLimitHandler);
        pipeline.addLast("framer", (ChannelHandler)new DelimiterBasedFrameDecoder(8192, false, Delimiters.lineDelimiter()));
        pipeline.addLast("encoderResponse", (ChannelHandler)this.createEncoder());
        pipeline.addLast("streamer", (ChannelHandler)new ChunkedWriteHandler());
        pipeline.addLast("timeoutHandler", (ChannelHandler)new TimeoutHandler((Timer)this.timer, this.timeout));
        pipeline.addLast("coreHandler", (ChannelHandler)this.createHandler());
        return pipeline;
    }

    protected abstract ChannelUpstreamHandler createHandler();

    protected abstract OneToOneEncoder createEncoder();
}

