/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.impl;

import java.util.LinkedList;
import org.apache.james.protocols.api.ConnectHandler;
import org.apache.james.protocols.api.ConnectHandlerResultHandler;
import org.apache.james.protocols.api.DisconnectHandler;
import org.apache.james.protocols.api.LineHandler;
import org.apache.james.protocols.api.LineHandlerResultHandler;
import org.apache.james.protocols.api.ProtocolHandlerChain;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.impl.ChannelAttributeSupport;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;

public abstract class AbstractChannelUpstreamHandler
extends SimpleChannelUpstreamHandler
implements ChannelAttributeSupport {
    private ProtocolHandlerChain chain;

    public AbstractChannelUpstreamHandler(ProtocolHandlerChain chain) {
        this.chain = chain;
    }

    public void channelBound(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        attributes.set(ctx.getChannel(), (Object)this.createSession(ctx));
        super.channelBound(ctx, e);
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        LinkedList connectHandlers = this.chain.getHandlers(ConnectHandler.class);
        LinkedList resultHandlers = this.chain.getHandlers(ConnectHandlerResultHandler.class);
        ProtocolSession session = (ProtocolSession)attributes.get(ctx.getChannel());
        session.getLogger().info("Connection established from " + session.getRemoteHost() + " (" + session.getRemoteIPAddress() + ")");
        if (connectHandlers != null) {
            for (int i = 0; i < connectHandlers.size(); ++i) {
                ConnectHandler cHandler = (ConnectHandler)connectHandlers.get(i);
                long start = System.currentTimeMillis();
                boolean disconnect = ((ConnectHandler)connectHandlers.get(i)).onConnect(session);
                long executionTime = System.currentTimeMillis() - start;
                for (int a = 0; a < resultHandlers.size(); ++a) {
                    disconnect = ((ConnectHandlerResultHandler)resultHandlers.get(a)).onResponse(session, disconnect, executionTime, cHandler);
                }
                if (!disconnect) continue;
                ctx.getChannel().disconnect();
                break;
            }
        }
        super.channelConnected(ctx, e);
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        LinkedList connectHandlers = this.chain.getHandlers(DisconnectHandler.class);
        ProtocolSession session = (ProtocolSession)attributes.get(ctx.getChannel());
        if (connectHandlers != null) {
            for (int i = 0; i < connectHandlers.size(); ++i) {
                DisconnectHandler cHandler = (DisconnectHandler)connectHandlers.get(i);
                ((DisconnectHandler)connectHandlers.get(i)).onDisconnect(session);
            }
        }
        super.channelDisconnected(ctx, e);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        ProtocolSession pSession = (ProtocolSession)attributes.get(ctx.getChannel());
        LinkedList lineHandlers = this.chain.getHandlers(LineHandler.class);
        LinkedList resultHandlers = this.chain.getHandlers(LineHandlerResultHandler.class);
        if (lineHandlers.size() > 0) {
            byte[] line;
            ChannelBuffer buf = (ChannelBuffer)e.getMessage();
            if (buf.hasArray()) {
                line = buf.array();
            } else {
                line = new byte[buf.capacity()];
                buf.getBytes(0, line);
            }
            LineHandler lHandler = (LineHandler)lineHandlers.getLast();
            long start = System.currentTimeMillis();
            boolean disconnect = lHandler.onLine(pSession, line);
            long executionTime = System.currentTimeMillis() - start;
            for (int i = 0; i < resultHandlers.size(); ++i) {
                disconnect = ((LineHandlerResultHandler)resultHandlers.get(i)).onResponse(pSession, disconnect, executionTime, lHandler);
            }
            if (disconnect) {
                ctx.getChannel().disconnect();
            }
        }
        super.messageReceived(ctx, e);
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        ProtocolSession session = (ProtocolSession)attributes.get(ctx.getChannel());
        if (session != null) {
            session.getLogger().info("Connection closed for " + session.getRemoteHost() + " (" + session.getRemoteIPAddress() + ")");
        }
        this.cleanup(ctx.getChannel());
        super.channelClosed(ctx, e);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        if (!(e.getCause() instanceof TooLongFrameException)) {
            this.cleanup(ctx.getChannel());
        }
    }

    protected void cleanup(Channel channel) {
        ProtocolSession session = (ProtocolSession)attributes.remove(channel);
        if (session != null) {
            session.resetState();
            session = null;
        }
    }

    protected abstract ProtocolSession createSession(ChannelHandlerContext var1) throws Exception;
}

