/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLEngine;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.TLSSupportedSession;
import org.apache.james.protocols.impl.SessionLog;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedStream;
import org.slf4j.Logger;

public abstract class AbstractSession
implements TLSSupportedSession {
    protected ChannelHandlerContext handlerContext;
    protected InetSocketAddress socketAddress;
    private Logger logger;
    private SessionLog pLog = null;
    protected SSLEngine engine;
    protected String user;
    private String id;

    public AbstractSession(Logger logger, ChannelHandlerContext handlerContext, SSLEngine engine) {
        this.handlerContext = handlerContext;
        this.socketAddress = (InetSocketAddress)handlerContext.getChannel().getRemoteAddress();
        this.logger = logger;
        this.engine = engine;
        this.id = handlerContext.getChannel().getId() + "";
    }

    public AbstractSession(Logger logger, ChannelHandlerContext handlerContext) {
        this(logger, handlerContext, null);
    }

    public String getRemoteHost() {
        return this.socketAddress.getHostName();
    }

    public String getRemoteIPAddress() {
        return this.socketAddress.getAddress().getHostAddress();
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public ChannelHandlerContext getChannelHandlerContext() {
        return this.handlerContext;
    }

    public boolean isStartTLSSupported() {
        return this.engine != null;
    }

    public boolean isTLSStarted() {
        if (this.isStartTLSSupported()) {
            return this.getChannelHandlerContext().getPipeline().get("sslHandler") != null;
        }
        return false;
    }

    public void startTLS() throws IOException {
        if (this.isStartTLSSupported() && !this.isTLSStarted()) {
            this.getChannelHandlerContext().getChannel().setReadable(false);
            SslHandler filter = new SslHandler(this.engine);
            filter.getEngine().setUseClientMode(false);
            this.resetState();
            this.getChannelHandlerContext().getPipeline().addFirst("sslHandler", (ChannelHandler)filter);
            this.getChannelHandlerContext().getChannel().setReadable(true);
        }
    }

    public Logger getLogger() {
        if (this.pLog == null) {
            this.pLog = new SessionLog(this.getSessionID(), this.logger);
        }
        return this.pLog;
    }

    public void writeResponse(final Response response) {
        Channel channel = this.getChannelHandlerContext().getChannel();
        if (response != null && channel.isConnected()) {
            channel.write((Object)response).addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture c) throws Exception {
                    if (response.isEndSession() && c.getChannel().isConnected()) {
                        c.getChannel().close();
                    }
                }
            });
        }
    }

    public void writeStream(InputStream stream) {
        Channel channel = this.getChannelHandlerContext().getChannel();
        if (stream != null && channel.isConnected()) {
            channel.write((Object)new ChunkedStream(stream));
        }
    }

    public String getSessionID() {
        return this.id;
    }
}

