/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.impl;

import org.apache.james.protocols.api.LineHandler;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.impl.ChannelAttributeSupport;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineHandlerUpstreamHandler<Session extends ProtocolSession>
extends SimpleChannelUpstreamHandler
implements ChannelAttributeSupport {
    private LineHandler<Session> handler;

    public LineHandlerUpstreamHandler(LineHandler<Session> handler) {
        this.handler = handler;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        byte[] line;
        ProtocolSession pSession = (ProtocolSession)attributes.get(ctx.getChannel());
        ChannelBuffer buf = (ChannelBuffer)e.getMessage();
        if (buf.hasArray()) {
            line = buf.array();
        } else {
            line = new byte[buf.capacity()];
            buf.getBytes(0, line);
        }
        boolean disconnect = this.handler.onLine(pSession, line);
        if (disconnect) {
            ctx.getChannel().disconnect();
        }
    }
}

