/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.handler;

import org.apache.camel.processor.RedeliveryPolicy;
import org.apache.camel.spring.ErrorHandlerType;
import org.apache.camel.spring.handler.BeanDefinitionParser;
import org.apache.camel.util.ObjectHelper;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ErrorHandlerDefinitionParser
extends BeanDefinitionParser {
    protected BeanDefinitionParser redeliveryPolicyParser = new RedeliveryPolicyDefinitionParser(RedeliveryPolicy.class);

    public ErrorHandlerDefinitionParser() {
        super(null);
    }

    protected Class getBeanClass(Element element) {
        ErrorHandlerType type = ErrorHandlerType.DefaultErrorHandler;
        if (ObjectHelper.isNotEmpty((Object)element.getAttribute("type"))) {
            type = ErrorHandlerType.valueOf(element.getAttribute("type"));
        }
        return type.getTypeAsClass();
    }

    protected boolean isEligibleAttribute(String attributeName) {
        if (attributeName == null || "id".equals(attributeName)) {
            return false;
        }
        return !attributeName.equals("xmlns") && !attributeName.startsWith("xmlns:") && !attributeName.equals("type") && !attributeName.equals("onRedeliveryRef") && !attributeName.equals("onRetryWhileRef") && !attributeName.equals("transactionTemplateRef") && !attributeName.equals("transactionManagerRef");
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        ErrorHandlerType type = ErrorHandlerType.DefaultErrorHandler;
        if (ObjectHelper.isNotEmpty((Object)element.getAttribute("type"))) {
            type = ErrorHandlerType.valueOf(element.getAttribute("type"));
        }
        if (type.equals((Object)ErrorHandlerType.NoErrorHandler) || type.equals((Object)ErrorHandlerType.LoggingErrorHandler)) {
            return;
        }
        if (type.equals((Object)ErrorHandlerType.DefaultErrorHandler) || type.equals((Object)ErrorHandlerType.DeadLetterChannel) || type.equals((Object)ErrorHandlerType.TransactionErrorHandler)) {
            NodeList list = element.getChildNodes();
            int size = list.getLength();
            for (int i = 0; i < size; ++i) {
                Node child = list.item(i);
                if (!(child instanceof Element)) continue;
                Element childElement = (Element)child;
                String localName = child.getLocalName();
                if (!localName.equals("redeliveryPolicy")) continue;
                BeanDefinition redeliveryPolicyDefinition = this.redeliveryPolicyParser.parse(childElement, parserContext);
                builder.addPropertyValue(localName, (Object)redeliveryPolicyDefinition);
            }
            this.parserRefAttribute(element, "onRedeliveryRef", "onRedelivery", builder);
        }
        if (type.equals((Object)ErrorHandlerType.TransactionErrorHandler)) {
            this.parserRefAttribute(element, "transactionTemplateRef", "transactionTemplate", builder);
            this.parserRefAttribute(element, "transactionManagerRef", "transactionManager", builder);
        }
    }

    private void parserRefAttribute(Element element, String attributeName, String propertyName, BeanDefinitionBuilder builder) {
        NamedNodeMap attributes = element.getAttributes();
        for (int x = 0; x < attributes.getLength(); ++x) {
            Attr attribute = (Attr)attributes.item(x);
            String name = attribute.getLocalName();
            if (!name.equals(attributeName)) continue;
            Assert.state((boolean)StringUtils.hasText((String)propertyName), (String)"Illegal property name returned from 'extractPropertyName(String)': cannot be null or empty.");
            builder.addPropertyReference(propertyName, attribute.getValue());
        }
    }

    protected class RedeliveryPolicyDefinitionParser
    extends BeanDefinitionParser {
        public RedeliveryPolicyDefinitionParser(Class type) {
            super(type);
        }

        protected boolean shouldGenerateId() {
            return true;
        }
    }
}

