/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.dnsservice.library;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.mailet.HostAddress;
import org.slf4j.Logger;

public class MXHostAddressIterator
implements Iterator<HostAddress> {
    private Iterator<HostAddress> addresses = null;
    private Iterator<String> hosts;
    private DNSService dns;
    private boolean useSingleIP;
    private Logger logger;
    private int defaultPort;

    public MXHostAddressIterator(Iterator<String> hosts, DNSService dns, boolean useSingleIP, Logger logger) {
        this(hosts, 25, dns, useSingleIP, logger);
    }

    public MXHostAddressIterator(Iterator<String> hosts, int defaultPort, DNSService dns, boolean useSingleIP, Logger logger) {
        this.hosts = hosts;
        this.dns = dns;
        this.useSingleIP = useSingleIP;
        this.logger = logger;
        this.defaultPort = defaultPort;
        this.init();
    }

    @Override
    public boolean hasNext() {
        return this.addresses.hasNext();
    }

    private void init() {
        ArrayList<HostAddress> hAddresses = new ArrayList<HostAddress>();
        while (this.hosts.hasNext()) {
            String hostname;
            String port;
            String nextHostname = this.hosts.next();
            int idx = nextHostname.indexOf(58);
            if (idx > 0) {
                port = nextHostname.substring(idx + 1);
                hostname = nextHostname.substring(0, idx);
            } else {
                hostname = nextHostname;
                port = this.defaultPort + "";
            }
            InetAddress[] addrs = null;
            try {
                addrs = this.useSingleIP ? new InetAddress[]{this.dns.getByName(hostname)} : this.dns.getAllByName(hostname);
                for (int i = 0; i < addrs.length; ++i) {
                    hAddresses.add(new HostAddress(hostname, "smtp://" + addrs[i].getHostAddress() + ":" + port));
                }
            }
            catch (UnknownHostException uhe) {
                StringBuffer logBuffer = new StringBuffer(128).append("Couldn't resolve IP address for discovered host ").append(hostname).append(".");
                this.logger.error(logBuffer.toString());
            }
        }
        this.addresses = hAddresses.iterator();
    }

    @Override
    public HostAddress next() {
        return this.addresses.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove not supported by this iterator");
    }
}

