/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.dnsservice.library.inetnetwork;

import java.net.UnknownHostException;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.dnsservice.library.inetnetwork.model.Inet4Network;
import org.apache.james.dnsservice.library.inetnetwork.model.Inet6Network;
import org.apache.james.dnsservice.library.inetnetwork.model.InetNetwork;

public class InetNetworkBuilder {
    private DNSService dnsService;

    public InetNetworkBuilder(DNSService dnsServer) {
        this.dnsService = dnsServer;
    }

    public InetNetwork getFromString(String netspec) throws UnknownHostException {
        return InetNetworkBuilder.isV6(netspec) ? this.getV6FromString(netspec) : this.getV4FromString(netspec);
    }

    public static boolean isV6(String netspec) {
        return netspec.contains(":");
    }

    private InetNetwork getV4FromString(String netspec) throws UnknownHostException {
        if (netspec.endsWith("*")) {
            netspec = InetNetworkBuilder.normalizeV4FromAsterisk(netspec);
        } else {
            int iSlash = netspec.indexOf(47);
            if (iSlash == -1) {
                netspec = netspec + "/255.255.255.255";
            } else if (netspec.indexOf(46, iSlash) == -1) {
                netspec = InetNetworkBuilder.normalizeV4FromCIDR(netspec);
            }
        }
        return new Inet4Network(this.dnsService.getByName(netspec.substring(0, netspec.indexOf(47))), this.dnsService.getByName(netspec.substring(netspec.indexOf(47) + 1)));
    }

    private InetNetwork getV6FromString(String netspec) throws UnknownHostException {
        if (netspec.endsWith("*")) {
            throw new UnsupportedOperationException("Wildcard for IPv6 not supported");
        }
        if ((netspec = netspec.replaceAll("%", "/")).indexOf(47) == -1) {
            netspec = netspec + "/32768";
        }
        return new Inet6Network(this.dnsService.getByName(netspec.substring(0, netspec.indexOf(47))), new Integer(netspec.substring(netspec.indexOf(47) + 1)));
    }

    private static String normalizeV4FromAsterisk(String netspec) {
        String[] masks = new String[]{"0.0.0.0/0.0.0.0", "0.0.0/255.0.0.0", "0.0/255.255.0.0", "0/255.255.255.0"};
        char[] srcb = netspec.toCharArray();
        int octets = 0;
        for (int i = 1; i < netspec.length(); ++i) {
            if (srcb[i] != '.') continue;
            ++octets;
        }
        return octets == 0 ? masks[0] : netspec.substring(0, netspec.length() - 1).concat(masks[octets]);
    }

    private static String normalizeV4FromCIDR(String netspec) {
        int bits = 32 - Integer.parseInt(netspec.substring(netspec.indexOf(47) + 1));
        int mask = bits == 32 ? 0 : -1 - ((1 << bits) - 1);
        return netspec.substring(0, netspec.indexOf(47) + 1) + Integer.toString(mask >> 24 & 0xFF, 10) + "." + Integer.toString(mask >> 16 & 0xFF, 10) + "." + Integer.toString(mask >> 8 & 0xFF, 10) + "." + Integer.toString(mask >> 0 & 0xFF, 10);
    }
}

